# coding: utf-8

"""
    AI Hub API

    The AI Hub REST API. Please see https://platform.instabase.com/docs/aihub/ for more details.

    The version of the OpenAPI document: 0.1
    Contact: support@instabase.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class RunAppRequest(BaseModel):
    """
    RunAppRequest
    """ # noqa: E501
    app_name: Optional[StrictStr] = Field(default=None, description="The name of the app to run.")
    app_id: Optional[StrictStr] = Field(default=None, description="The ID of the app to run.")
    batch_id: Optional[StrictInt] = Field(default=None, description="The batch ID.")
    input_dir: Optional[StrictInt] = Field(default=None, description="Input directory.")
    output_dir: Optional[StrictStr] = Field(default=None, description="Output directory")
    owner: Optional[StrictStr] = Field(default=None, description="Owner of the app run.")
    settings: Optional[Dict[str, Any]] = Field(default=None, description="JSON object containing settings for the app run.")
    __properties: ClassVar[List[str]] = ["app_name", "app_id", "batch_id", "input_dir", "output_dir", "owner", "settings"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of RunAppRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of RunAppRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "app_name": obj.get("app_name"),
            "app_id": obj.get("app_id"),
            "batch_id": obj.get("batch_id"),
            "input_dir": obj.get("input_dir"),
            "output_dir": obj.get("output_dir"),
            "owner": obj.get("owner"),
            "settings": obj.get("settings")
        })
        return _obj


