# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_rpm.configuration import Configuration


class PrunePackages(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'repo_hrefs': 'list[str]',
        'keep_days': 'int',
        'dry_run': 'bool'
    }

    attribute_map = {
        'repo_hrefs': 'repo_hrefs',
        'keep_days': 'keep_days',
        'dry_run': 'dry_run'
    }

    def __init__(self, repo_hrefs=None, keep_days=14, dry_run=False, local_vars_configuration=None):  # noqa: E501
        """PrunePackages - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._repo_hrefs = None
        self._keep_days = None
        self._dry_run = None
        self.discriminator = None

        self.repo_hrefs = repo_hrefs
        if keep_days is not None:
            self.keep_days = keep_days
        if dry_run is not None:
            self.dry_run = dry_run

    @property
    def repo_hrefs(self):
        """Gets the repo_hrefs of this PrunePackages.  # noqa: E501

        Will prune old packages from the specified list of repos. Use ['*'] to specify all repos. Will prune based on the specified repositories' latest_versions.  # noqa: E501

        :return: The repo_hrefs of this PrunePackages.  # noqa: E501
        :rtype: list[str]
        """
        return self._repo_hrefs

    @repo_hrefs.setter
    def repo_hrefs(self, repo_hrefs):
        """Sets the repo_hrefs of this PrunePackages.

        Will prune old packages from the specified list of repos. Use ['*'] to specify all repos. Will prune based on the specified repositories' latest_versions.  # noqa: E501

        :param repo_hrefs: The repo_hrefs of this PrunePackages.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and repo_hrefs is None:  # noqa: E501
            raise ValueError("Invalid value for `repo_hrefs`, must not be `None`")  # noqa: E501

        self._repo_hrefs = repo_hrefs

    @property
    def keep_days(self):
        """Gets the keep_days of this PrunePackages.  # noqa: E501

        Prune packages introduced *prior-to* this many days ago. Default is 14. A value of 0 implies 'keep latest package only.'  # noqa: E501

        :return: The keep_days of this PrunePackages.  # noqa: E501
        :rtype: int
        """
        return self._keep_days

    @keep_days.setter
    def keep_days(self, keep_days):
        """Sets the keep_days of this PrunePackages.

        Prune packages introduced *prior-to* this many days ago. Default is 14. A value of 0 implies 'keep latest package only.'  # noqa: E501

        :param keep_days: The keep_days of this PrunePackages.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                keep_days is not None and keep_days < 0):  # noqa: E501
            raise ValueError("Invalid value for `keep_days`, must be a value greater than or equal to `0`")  # noqa: E501

        self._keep_days = keep_days

    @property
    def dry_run(self):
        """Gets the dry_run of this PrunePackages.  # noqa: E501

        Determine what would-be-pruned and log the list of packages. Intended as a debugging aid.  # noqa: E501

        :return: The dry_run of this PrunePackages.  # noqa: E501
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """Sets the dry_run of this PrunePackages.

        Determine what would-be-pruned and log the list of packages. Intended as a debugging aid.  # noqa: E501

        :param dry_run: The dry_run of this PrunePackages.  # noqa: E501
        :type: bool
        """

        self._dry_run = dry_run

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PrunePackages):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PrunePackages):
            return True

        return self.to_dict() != other.to_dict()
