"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shell = shell;
const child_process_1 = require("child_process");
function shell(command, ...args) {
    const proc = (0, child_process_1.spawnSync)(command, args);
    if (proc.error) {
        throw new Error(proc.error.message);
    }
    if (proc.status !== 0) {
        throw new Error(`non-zero exist code ${proc.status}: ${proc.stdout} ${proc.stderr}`);
    }
    return proc.stdout.toString('utf-8');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX3NoZWxsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL19zaGVsbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBLHNCQVlDO0FBZEQsaURBQTBDO0FBRTFDLFNBQWdCLEtBQUssQ0FBQyxPQUFlLEVBQUUsR0FBRyxJQUFjO0lBQ3RELE1BQU0sSUFBSSxHQUFHLElBQUEseUJBQVMsRUFBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFFdEMsSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDZixNQUFNLElBQUksS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVELElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztRQUN0QixNQUFNLElBQUksS0FBSyxDQUFDLHVCQUF1QixJQUFJLENBQUMsTUFBTSxLQUFLLElBQUksQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7SUFDdkYsQ0FBQztJQUVELE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUM7QUFDdkMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHNwYXduU3luYyB9IGZyb20gJ2NoaWxkX3Byb2Nlc3MnO1xuXG5leHBvcnQgZnVuY3Rpb24gc2hlbGwoY29tbWFuZDogc3RyaW5nLCAuLi5hcmdzOiBzdHJpbmdbXSk6IHN0cmluZyB7XG4gIGNvbnN0IHByb2MgPSBzcGF3blN5bmMoY29tbWFuZCwgYXJncyk7XG5cbiAgaWYgKHByb2MuZXJyb3IpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IocHJvYy5lcnJvci5tZXNzYWdlKTtcbiAgfVxuXG4gIGlmIChwcm9jLnN0YXR1cyAhPT0gMCkge1xuICAgIHRocm93IG5ldyBFcnJvcihgbm9uLXplcm8gZXhpc3QgY29kZSAke3Byb2Muc3RhdHVzfTogJHtwcm9jLnN0ZG91dH0gJHtwcm9jLnN0ZGVycn1gKTtcbiAgfVxuXG4gIHJldHVybiBwcm9jLnN0ZG91dC50b1N0cmluZygndXRmLTgnKTtcbn0iXX0=