# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ResourceArgs', 'Resource']

@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[Union[pulumi.Asset, pulumi.Archive]],
                 remote_tag: pulumi.Input[_builtins.str],
                 image_tarball_hash: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Resource resource.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] image: Image tarball thing.
        :param pulumi.Input[_builtins.str] remote_tag: The tag to save the image to.
        :param pulumi.Input[_builtins.str] image_tarball_hash: Hash of the image tarball.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "remote_tag", remote_tag)
        if image_tarball_hash is not None:
            pulumi.set(__self__, "image_tarball_hash", image_tarball_hash)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]:
        """
        Image tarball thing.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="remoteTag")
    def remote_tag(self) -> pulumi.Input[_builtins.str]:
        """
        The tag to save the image to.
        """
        return pulumi.get(self, "remote_tag")

    @remote_tag.setter
    def remote_tag(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "remote_tag", value)

    @_builtins.property
    @pulumi.getter(name="imageTarballHash")
    def image_tarball_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hash of the image tarball.
        """
        return pulumi.get(self, "image_tarball_hash")

    @image_tarball_hash.setter
    def image_tarball_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_tarball_hash", value)


@pulumi.input_type
class _ResourceState:
    def __init__(__self__, *,
                 image: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 image_tarball_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_tag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Resource resources.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] image: Image tarball thing.
        :param pulumi.Input[_builtins.str] image_tarball_hash: Hash of the image tarball.
        :param pulumi.Input[_builtins.str] remote_tag: The tag to save the image to.
        """
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_tarball_hash is not None:
            pulumi.set(__self__, "image_tarball_hash", image_tarball_hash)
        if remote_tag is not None:
            pulumi.set(__self__, "remote_tag", remote_tag)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        Image tarball thing.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "image", value)

    @_builtins.property
    @pulumi.getter(name="imageTarballHash")
    def image_tarball_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hash of the image tarball.
        """
        return pulumi.get(self, "image_tarball_hash")

    @image_tarball_hash.setter
    def image_tarball_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_tarball_hash", value)

    @_builtins.property
    @pulumi.getter(name="remoteTag")
    def remote_tag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag to save the image to.
        """
        return pulumi.get(self, "remote_tag")

    @remote_tag.setter
    def remote_tag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_tag", value)


@pulumi.type_token("containerregistry:index/resource:Resource")
class Resource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 image_tarball_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Resource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] image: Image tarball thing.
        :param pulumi.Input[_builtins.str] image_tarball_hash: Hash of the image tarball.
        :param pulumi.Input[_builtins.str] remote_tag: The tag to save the image to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Resource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 image_tarball_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_tag: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceArgs.__new__(ResourceArgs)

            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            __props__.__dict__["image_tarball_hash"] = image_tarball_hash
            if remote_tag is None and not opts.urn:
                raise TypeError("Missing required property 'remote_tag'")
            __props__.__dict__["remote_tag"] = remote_tag
        super(Resource, __self__).__init__(
            'containerregistry:index/resource:Resource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            image: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
            image_tarball_hash: Optional[pulumi.Input[_builtins.str]] = None,
            remote_tag: Optional[pulumi.Input[_builtins.str]] = None) -> 'Resource':
        """
        Get an existing Resource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] image: Image tarball thing.
        :param pulumi.Input[_builtins.str] image_tarball_hash: Hash of the image tarball.
        :param pulumi.Input[_builtins.str] remote_tag: The tag to save the image to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceState.__new__(_ResourceState)

        __props__.__dict__["image"] = image
        __props__.__dict__["image_tarball_hash"] = image_tarball_hash
        __props__.__dict__["remote_tag"] = remote_tag
        return Resource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def image(self) -> pulumi.Output[Union[pulumi.Asset, pulumi.Archive]]:
        """
        Image tarball thing.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imageTarballHash")
    def image_tarball_hash(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Hash of the image tarball.
        """
        return pulumi.get(self, "image_tarball_hash")

    @_builtins.property
    @pulumi.getter(name="remoteTag")
    def remote_tag(self) -> pulumi.Output[_builtins.str]:
        """
        The tag to save the image to.
        """
        return pulumi.get(self, "remote_tag")

