# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.auth_details_holder import AuthDetailsHolder
from ..types.workspace_name_holder import WorkspaceNameHolder
from .raw_client import AsyncRawCheckClient, RawCheckClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CheckClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCheckClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCheckClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCheckClient
        """
        return self._raw_client

    def access(self, *, request: AuthDetailsHolder, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Check user access to workspace

        Parameters
        ----------
        request : AuthDetailsHolder

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.check.access(request={'key': 'value'
        }, )
        """
        _response = self._raw_client.access(request=request, request_options=request_options)
        return _response.data

    def get_workspace_name(self, *, request_options: typing.Optional[RequestOptions] = None) -> WorkspaceNameHolder:
        """
        User's default workspace name

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceNameHolder
            Authentication resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.check.get_workspace_name()
        """
        _response = self._raw_client.get_workspace_name(request_options=request_options)
        return _response.data


class AsyncCheckClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCheckClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCheckClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCheckClient
        """
        return self._raw_client

    async def access(
        self, *, request: AuthDetailsHolder, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Check user access to workspace

        Parameters
        ----------
        request : AuthDetailsHolder

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.check.access(request={'key': 'value'
            }, )
        asyncio.run(main())
        """
        _response = await self._raw_client.access(request=request, request_options=request_options)
        return _response.data

    async def get_workspace_name(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceNameHolder:
        """
        User's default workspace name

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceNameHolder
            Authentication resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.check.get_workspace_name()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_workspace_name(request_options=request_options)
        return _response.data
