# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .attachments.client import AsyncAttachmentsClient, AttachmentsClient
from .automation_rule_evaluators.client import AsyncAutomationRuleEvaluatorsClient, AutomationRuleEvaluatorsClient
from .chat_completions.client import AsyncChatCompletionsClient, ChatCompletionsClient
from .check.client import AsyncCheckClient, CheckClient
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.request_options import RequestOptions
from .datasets.client import AsyncDatasetsClient, DatasetsClient
from .environment import OpikApiEnvironment
from .experiments.client import AsyncExperimentsClient, ExperimentsClient
from .feedback_definitions.client import AsyncFeedbackDefinitionsClient, FeedbackDefinitionsClient
from .guardrails.client import AsyncGuardrailsClient, GuardrailsClient
from .llm_provider_key.client import AsyncLlmProviderKeyClient, LlmProviderKeyClient
from .open_telemetry_ingestion.client import AsyncOpenTelemetryIngestionClient, OpenTelemetryIngestionClient
from .optimizations.client import AsyncOptimizationsClient, OptimizationsClient
from .projects.client import AsyncProjectsClient, ProjectsClient
from .prompts.client import AsyncPromptsClient, PromptsClient
from .raw_client import AsyncRawOpikApi, RawOpikApi
from .redirect.client import AsyncRedirectClient, RedirectClient
from .service_toggles.client import AsyncServiceTogglesClient, ServiceTogglesClient
from .spans.client import AsyncSpansClient, SpansClient
from .system_usage.client import AsyncSystemUsageClient, SystemUsageClient
from .traces.client import AsyncTracesClient, TracesClient
from .workspaces.client import AsyncWorkspacesClient, WorkspacesClient


class OpikApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : OpikApiEnvironment
        The environment to use for requests from the client. from .environment import OpikApiEnvironment

        Defaults to OpikApiEnvironment.DEFAULT



    api_key : typing.Optional[str]
    workspace_name : typing.Optional[str]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from Opik import OpikApi
    client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OpikApiEnvironment = OpikApiEnvironment.DEFAULT,
        api_key: typing.Optional[str] = None,
        workspace_name: typing.Optional[str] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            workspace_name=workspace_name,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = RawOpikApi(client_wrapper=self._client_wrapper)
        self.system_usage = SystemUsageClient(client_wrapper=self._client_wrapper)
        self.attachments = AttachmentsClient(client_wrapper=self._client_wrapper)
        self.check = CheckClient(client_wrapper=self._client_wrapper)
        self.automation_rule_evaluators = AutomationRuleEvaluatorsClient(client_wrapper=self._client_wrapper)
        self.chat_completions = ChatCompletionsClient(client_wrapper=self._client_wrapper)
        self.datasets = DatasetsClient(client_wrapper=self._client_wrapper)
        self.experiments = ExperimentsClient(client_wrapper=self._client_wrapper)
        self.feedback_definitions = FeedbackDefinitionsClient(client_wrapper=self._client_wrapper)
        self.guardrails = GuardrailsClient(client_wrapper=self._client_wrapper)
        self.llm_provider_key = LlmProviderKeyClient(client_wrapper=self._client_wrapper)
        self.open_telemetry_ingestion = OpenTelemetryIngestionClient(client_wrapper=self._client_wrapper)
        self.optimizations = OptimizationsClient(client_wrapper=self._client_wrapper)
        self.projects = ProjectsClient(client_wrapper=self._client_wrapper)
        self.prompts = PromptsClient(client_wrapper=self._client_wrapper)
        self.service_toggles = ServiceTogglesClient(client_wrapper=self._client_wrapper)
        self.spans = SpansClient(client_wrapper=self._client_wrapper)
        self.traces = TracesClient(client_wrapper=self._client_wrapper)
        self.workspaces = WorkspacesClient(client_wrapper=self._client_wrapper)
        self.redirect = RedirectClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> RawOpikApi:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOpikApi
        """
        return self._raw_client

    def is_alive(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            default response

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.is_alive()
        """
        _response = self._raw_client.is_alive(request_options=request_options)
        return _response.data

    def version(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            default response

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.version()
        """
        _response = self._raw_client.version(request_options=request_options)
        return _response.data


class AsyncOpikApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : OpikApiEnvironment
        The environment to use for requests from the client. from .environment import OpikApiEnvironment

        Defaults to OpikApiEnvironment.DEFAULT



    api_key : typing.Optional[str]
    workspace_name : typing.Optional[str]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from Opik import AsyncOpikApi
    client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OpikApiEnvironment = OpikApiEnvironment.DEFAULT,
        api_key: typing.Optional[str] = None,
        workspace_name: typing.Optional[str] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            workspace_name=workspace_name,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._raw_client = AsyncRawOpikApi(client_wrapper=self._client_wrapper)
        self.system_usage = AsyncSystemUsageClient(client_wrapper=self._client_wrapper)
        self.attachments = AsyncAttachmentsClient(client_wrapper=self._client_wrapper)
        self.check = AsyncCheckClient(client_wrapper=self._client_wrapper)
        self.automation_rule_evaluators = AsyncAutomationRuleEvaluatorsClient(client_wrapper=self._client_wrapper)
        self.chat_completions = AsyncChatCompletionsClient(client_wrapper=self._client_wrapper)
        self.datasets = AsyncDatasetsClient(client_wrapper=self._client_wrapper)
        self.experiments = AsyncExperimentsClient(client_wrapper=self._client_wrapper)
        self.feedback_definitions = AsyncFeedbackDefinitionsClient(client_wrapper=self._client_wrapper)
        self.guardrails = AsyncGuardrailsClient(client_wrapper=self._client_wrapper)
        self.llm_provider_key = AsyncLlmProviderKeyClient(client_wrapper=self._client_wrapper)
        self.open_telemetry_ingestion = AsyncOpenTelemetryIngestionClient(client_wrapper=self._client_wrapper)
        self.optimizations = AsyncOptimizationsClient(client_wrapper=self._client_wrapper)
        self.projects = AsyncProjectsClient(client_wrapper=self._client_wrapper)
        self.prompts = AsyncPromptsClient(client_wrapper=self._client_wrapper)
        self.service_toggles = AsyncServiceTogglesClient(client_wrapper=self._client_wrapper)
        self.spans = AsyncSpansClient(client_wrapper=self._client_wrapper)
        self.traces = AsyncTracesClient(client_wrapper=self._client_wrapper)
        self.workspaces = AsyncWorkspacesClient(client_wrapper=self._client_wrapper)
        self.redirect = AsyncRedirectClient(client_wrapper=self._client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOpikApi:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOpikApi
        """
        return self._raw_client

    async def is_alive(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            default response

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.is_alive()
        asyncio.run(main())
        """
        _response = await self._raw_client.is_alive(request_options=request_options)
        return _response.data

    async def version(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            default response

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.version()
        asyncio.run(main())
        """
        _response = await self._raw_client.version(request_options=request_options)
        return _response.data


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: OpikApiEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
