# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.guardrail_write import GuardrailWrite
from .raw_client import AsyncRawGuardrailsClient, RawGuardrailsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class GuardrailsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGuardrailsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGuardrailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGuardrailsClient
        """
        return self._raw_client

    def create_guardrails(
        self, *, guardrails: typing.Sequence[GuardrailWrite], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Batch guardrails for traces

        Parameters
        ----------
        guardrails : typing.Sequence[GuardrailWrite]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        from Opik import GuardrailWrite
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.guardrails.create_guardrails(guardrails=[GuardrailWrite(entity_id='entity_id', secondary_id='secondary_id', name="TOPIC", result="passed", config={'key': 'value'
        }, details={'key': 'value'
        }, )], )
        """
        _response = self._raw_client.create_guardrails(guardrails=guardrails, request_options=request_options)
        return _response.data


class AsyncGuardrailsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGuardrailsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGuardrailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGuardrailsClient
        """
        return self._raw_client

    async def create_guardrails(
        self, *, guardrails: typing.Sequence[GuardrailWrite], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Batch guardrails for traces

        Parameters
        ----------
        guardrails : typing.Sequence[GuardrailWrite]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import GuardrailWrite
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.guardrails.create_guardrails(guardrails=[GuardrailWrite(entity_id='entity_id', secondary_id='secondary_id', name="TOPIC", result="passed", config={'key': 'value'
            }, details={'key': 'value'
            }, )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_guardrails(guardrails=guardrails, request_options=request_options)
        return _response.data
