# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.json_node_write import JsonNodeWrite
from ..types.optimization_page_public import OptimizationPagePublic
from ..types.optimization_public import OptimizationPublic
from ..types.optimization_write_status import OptimizationWriteStatus
from .raw_client import AsyncRawOptimizationsClient, RawOptimizationsClient
from .types.optimization_update_status import OptimizationUpdateStatus

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OptimizationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOptimizationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOptimizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOptimizationsClient
        """
        return self._raw_client

    def find_optimizations(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        dataset_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        dataset_deleted: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptimizationPagePublic:
        """
        Find optimizations

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        dataset_id : typing.Optional[str]

        name : typing.Optional[str]

        dataset_deleted : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizationPagePublic
            Optimizations resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.optimizations.find_optimizations()
        """
        _response = self._raw_client.find_optimizations(
            page=page,
            size=size,
            dataset_id=dataset_id,
            name=name,
            dataset_deleted=dataset_deleted,
            request_options=request_options,
        )
        return _response.data

    def create_optimization(
        self,
        *,
        dataset_name: str,
        objective_name: str,
        status: OptimizationWriteStatus,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonNodeWrite] = OMIT,
        last_updated_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create optimization

        Parameters
        ----------
        dataset_name : str

        objective_name : str

        status : OptimizationWriteStatus

        id : typing.Optional[str]

        name : typing.Optional[str]

        metadata : typing.Optional[JsonNodeWrite]

        last_updated_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.optimizations.create_optimization(dataset_name='dataset_name', objective_name='objective_name', status="running", )
        """
        _response = self._raw_client.create_optimization(
            dataset_name=dataset_name,
            objective_name=objective_name,
            status=status,
            id=id,
            name=name,
            metadata=metadata,
            last_updated_at=last_updated_at,
            request_options=request_options,
        )
        return _response.data

    def upsert_optimization(
        self,
        *,
        dataset_name: str,
        objective_name: str,
        status: OptimizationWriteStatus,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonNodeWrite] = OMIT,
        last_updated_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Upsert optimization

        Parameters
        ----------
        dataset_name : str

        objective_name : str

        status : OptimizationWriteStatus

        id : typing.Optional[str]

        name : typing.Optional[str]

        metadata : typing.Optional[JsonNodeWrite]

        last_updated_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.optimizations.upsert_optimization(dataset_name='dataset_name', objective_name='objective_name', status="running", )
        """
        _response = self._raw_client.upsert_optimization(
            dataset_name=dataset_name,
            objective_name=objective_name,
            status=status,
            id=id,
            name=name,
            metadata=metadata,
            last_updated_at=last_updated_at,
            request_options=request_options,
        )
        return _response.data

    def delete_optimizations_by_id(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete optimizations by id

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.optimizations.delete_optimizations_by_id(ids=['ids'], )
        """
        _response = self._raw_client.delete_optimizations_by_id(ids=ids, request_options=request_options)
        return _response.data

    def get_optimization_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OptimizationPublic:
        """
        Get optimization by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizationPublic
            Optimization resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.optimizations.get_optimization_by_id(id='id', )
        """
        _response = self._raw_client.get_optimization_by_id(id, request_options=request_options)
        return _response.data

    def update_optimizations_by_id(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        status: typing.Optional[OptimizationUpdateStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update optimization by id

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        status : typing.Optional[OptimizationUpdateStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.optimizations.update_optimizations_by_id(id='id', )
        """
        _response = self._raw_client.update_optimizations_by_id(
            id, name=name, status=status, request_options=request_options
        )
        return _response.data


class AsyncOptimizationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOptimizationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOptimizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOptimizationsClient
        """
        return self._raw_client

    async def find_optimizations(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        dataset_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        dataset_deleted: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OptimizationPagePublic:
        """
        Find optimizations

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        dataset_id : typing.Optional[str]

        name : typing.Optional[str]

        dataset_deleted : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizationPagePublic
            Optimizations resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.optimizations.find_optimizations()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_optimizations(
            page=page,
            size=size,
            dataset_id=dataset_id,
            name=name,
            dataset_deleted=dataset_deleted,
            request_options=request_options,
        )
        return _response.data

    async def create_optimization(
        self,
        *,
        dataset_name: str,
        objective_name: str,
        status: OptimizationWriteStatus,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonNodeWrite] = OMIT,
        last_updated_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create optimization

        Parameters
        ----------
        dataset_name : str

        objective_name : str

        status : OptimizationWriteStatus

        id : typing.Optional[str]

        name : typing.Optional[str]

        metadata : typing.Optional[JsonNodeWrite]

        last_updated_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.optimizations.create_optimization(dataset_name='dataset_name', objective_name='objective_name', status="running", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_optimization(
            dataset_name=dataset_name,
            objective_name=objective_name,
            status=status,
            id=id,
            name=name,
            metadata=metadata,
            last_updated_at=last_updated_at,
            request_options=request_options,
        )
        return _response.data

    async def upsert_optimization(
        self,
        *,
        dataset_name: str,
        objective_name: str,
        status: OptimizationWriteStatus,
        id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonNodeWrite] = OMIT,
        last_updated_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Upsert optimization

        Parameters
        ----------
        dataset_name : str

        objective_name : str

        status : OptimizationWriteStatus

        id : typing.Optional[str]

        name : typing.Optional[str]

        metadata : typing.Optional[JsonNodeWrite]

        last_updated_at : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.optimizations.upsert_optimization(dataset_name='dataset_name', objective_name='objective_name', status="running", )
        asyncio.run(main())
        """
        _response = await self._raw_client.upsert_optimization(
            dataset_name=dataset_name,
            objective_name=objective_name,
            status=status,
            id=id,
            name=name,
            metadata=metadata,
            last_updated_at=last_updated_at,
            request_options=request_options,
        )
        return _response.data

    async def delete_optimizations_by_id(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete optimizations by id

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.optimizations.delete_optimizations_by_id(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_optimizations_by_id(ids=ids, request_options=request_options)
        return _response.data

    async def get_optimization_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OptimizationPublic:
        """
        Get optimization by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OptimizationPublic
            Optimization resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.optimizations.get_optimization_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_optimization_by_id(id, request_options=request_options)
        return _response.data

    async def update_optimizations_by_id(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        status: typing.Optional[OptimizationUpdateStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update optimization by id

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        status : typing.Optional[OptimizationUpdateStatus]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.optimizations.update_optimizations_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_optimizations_by_id(
            id, name=name, status=status, request_options=request_options
        )
        return _response.data
