# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.configuration_timeout_to_mark_thread_as_inactive import ConfigurationTimeoutToMarkThreadAsInactive
from ..types.configuration_write import ConfigurationWrite
from ..types.feedback_score_names import FeedbackScoreNames
from ..types.project_detailed import ProjectDetailed
from ..types.project_metric_response_public import ProjectMetricResponsePublic
from ..types.project_page_public import ProjectPagePublic
from ..types.project_public import ProjectPublic
from ..types.project_stats_summary import ProjectStatsSummary
from .raw_client import AsyncRawProjectsClient, RawProjectsClient
from .types.project_metric_request_public_interval import ProjectMetricRequestPublicInterval
from .types.project_metric_request_public_metric_type import ProjectMetricRequestPublicMetricType
from .types.project_update_visibility import ProjectUpdateVisibility
from .types.project_write_visibility import ProjectWriteVisibility

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProjectsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProjectsClient
        """
        return self._raw_client

    def find_projects(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectPagePublic:
        """
        Find projects

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectPagePublic
            Project resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.find_projects()
        """
        _response = self._raw_client.find_projects(
            page=page, size=size, name=name, sorting=sorting, request_options=request_options
        )
        return _response.data

    def create_project(
        self,
        *,
        name: str,
        visibility: typing.Optional[ProjectWriteVisibility] = OMIT,
        description: typing.Optional[str] = OMIT,
        configuration: typing.Optional[ConfigurationWrite] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create project

        Parameters
        ----------
        name : str

        visibility : typing.Optional[ProjectWriteVisibility]

        description : typing.Optional[str]

        configuration : typing.Optional[ConfigurationWrite]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.create_project(name='name', )
        """
        _response = self._raw_client.create_project(
            name=name,
            visibility=visibility,
            description=description,
            configuration=configuration,
            request_options=request_options,
        )
        return _response.data

    def get_project_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ProjectPublic:
        """
        Get project by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectPublic
            Project resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.get_project_by_id(id='id', )
        """
        _response = self._raw_client.get_project_by_id(id, request_options=request_options)
        return _response.data

    def delete_project_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete project by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.delete_project_by_id(id='id', )
        """
        _response = self._raw_client.delete_project_by_id(id, request_options=request_options)
        return _response.data

    def update_project(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        visibility: typing.Optional[ProjectUpdateVisibility] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update project by id

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        visibility : typing.Optional[ProjectUpdateVisibility]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.update_project(id='id', )
        """
        _response = self._raw_client.update_project(
            id, name=name, description=description, visibility=visibility, request_options=request_options
        )
        return _response.data

    def delete_projects_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete projects batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.delete_projects_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_projects_batch(ids=ids, request_options=request_options)
        return _response.data

    def find_feedback_score_names_by_project_ids(
        self, *, project_ids: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> FeedbackScoreNames:
        """
        Find Feedback Score names By Project Ids

        Parameters
        ----------
        project_ids : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackScoreNames
            Feedback Scores resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.find_feedback_score_names_by_project_ids()
        """
        _response = self._raw_client.find_feedback_score_names_by_project_ids(
            project_ids=project_ids, request_options=request_options
        )
        return _response.data

    def get_project_metrics(
        self,
        id: str,
        *,
        metric_type: typing.Optional[ProjectMetricRequestPublicMetricType] = OMIT,
        interval: typing.Optional[ProjectMetricRequestPublicInterval] = OMIT,
        interval_start: typing.Optional[dt.datetime] = OMIT,
        interval_end: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectMetricResponsePublic:
        """
        Gets specified metrics for a project

        Parameters
        ----------
        id : str

        metric_type : typing.Optional[ProjectMetricRequestPublicMetricType]

        interval : typing.Optional[ProjectMetricRequestPublicInterval]

        interval_start : typing.Optional[dt.datetime]

        interval_end : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectMetricResponsePublic
            Project Metrics

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.get_project_metrics(id='id', )
        """
        _response = self._raw_client.get_project_metrics(
            id,
            metric_type=metric_type,
            interval=interval,
            interval_start=interval_start,
            interval_end=interval_end,
            request_options=request_options,
        )
        return _response.data

    def get_project_stats(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectStatsSummary:
        """
        Get Project Stats

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectStatsSummary
            Project Stats

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.get_project_stats()
        """
        _response = self._raw_client.get_project_stats(
            page=page, size=size, name=name, sorting=sorting, request_options=request_options
        )
        return _response.data

    def retrieve_project(
        self, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectDetailed:
        """
        Retrieve project

        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectDetailed
            Project resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.retrieve_project(name='name', )
        """
        _response = self._raw_client.retrieve_project(name=name, request_options=request_options)
        return _response.data

    def upsert_project_configurations(
        self,
        id: str,
        *,
        timeout_to_mark_thread_as_inactive: typing.Optional[ConfigurationTimeoutToMarkThreadAsInactive] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Upsert project configurations

        Parameters
        ----------
        id : str

        timeout_to_mark_thread_as_inactive : typing.Optional[ConfigurationTimeoutToMarkThreadAsInactive]
            minimum precision supported is seconds, please use a duration with seconds precision or higher. Also, the max duration allowed is 7 days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.projects.upsert_project_configurations(id='id', )
        """
        _response = self._raw_client.upsert_project_configurations(
            id, timeout_to_mark_thread_as_inactive=timeout_to_mark_thread_as_inactive, request_options=request_options
        )
        return _response.data


class AsyncProjectsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProjectsClient
        """
        return self._raw_client

    async def find_projects(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectPagePublic:
        """
        Find projects

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectPagePublic
            Project resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.find_projects()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_projects(
            page=page, size=size, name=name, sorting=sorting, request_options=request_options
        )
        return _response.data

    async def create_project(
        self,
        *,
        name: str,
        visibility: typing.Optional[ProjectWriteVisibility] = OMIT,
        description: typing.Optional[str] = OMIT,
        configuration: typing.Optional[ConfigurationWrite] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create project

        Parameters
        ----------
        name : str

        visibility : typing.Optional[ProjectWriteVisibility]

        description : typing.Optional[str]

        configuration : typing.Optional[ConfigurationWrite]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.create_project(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_project(
            name=name,
            visibility=visibility,
            description=description,
            configuration=configuration,
            request_options=request_options,
        )
        return _response.data

    async def get_project_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectPublic:
        """
        Get project by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectPublic
            Project resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.get_project_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_project_by_id(id, request_options=request_options)
        return _response.data

    async def delete_project_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete project by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.delete_project_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_project_by_id(id, request_options=request_options)
        return _response.data

    async def update_project(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        visibility: typing.Optional[ProjectUpdateVisibility] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update project by id

        Parameters
        ----------
        id : str

        name : typing.Optional[str]

        description : typing.Optional[str]

        visibility : typing.Optional[ProjectUpdateVisibility]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.update_project(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_project(
            id, name=name, description=description, visibility=visibility, request_options=request_options
        )
        return _response.data

    async def delete_projects_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete projects batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.delete_projects_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_projects_batch(ids=ids, request_options=request_options)
        return _response.data

    async def find_feedback_score_names_by_project_ids(
        self, *, project_ids: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> FeedbackScoreNames:
        """
        Find Feedback Score names By Project Ids

        Parameters
        ----------
        project_ids : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FeedbackScoreNames
            Feedback Scores resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.find_feedback_score_names_by_project_ids()
        asyncio.run(main())
        """
        _response = await self._raw_client.find_feedback_score_names_by_project_ids(
            project_ids=project_ids, request_options=request_options
        )
        return _response.data

    async def get_project_metrics(
        self,
        id: str,
        *,
        metric_type: typing.Optional[ProjectMetricRequestPublicMetricType] = OMIT,
        interval: typing.Optional[ProjectMetricRequestPublicInterval] = OMIT,
        interval_start: typing.Optional[dt.datetime] = OMIT,
        interval_end: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectMetricResponsePublic:
        """
        Gets specified metrics for a project

        Parameters
        ----------
        id : str

        metric_type : typing.Optional[ProjectMetricRequestPublicMetricType]

        interval : typing.Optional[ProjectMetricRequestPublicInterval]

        interval_start : typing.Optional[dt.datetime]

        interval_end : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectMetricResponsePublic
            Project Metrics

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.get_project_metrics(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_project_metrics(
            id,
            metric_type=metric_type,
            interval=interval,
            interval_start=interval_start,
            interval_end=interval_end,
            request_options=request_options,
        )
        return _response.data

    async def get_project_stats(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        sorting: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectStatsSummary:
        """
        Get Project Stats

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        sorting : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectStatsSummary
            Project Stats

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.get_project_stats()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_project_stats(
            page=page, size=size, name=name, sorting=sorting, request_options=request_options
        )
        return _response.data

    async def retrieve_project(
        self, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectDetailed:
        """
        Retrieve project

        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectDetailed
            Project resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.retrieve_project(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_project(name=name, request_options=request_options)
        return _response.data

    async def upsert_project_configurations(
        self,
        id: str,
        *,
        timeout_to_mark_thread_as_inactive: typing.Optional[ConfigurationTimeoutToMarkThreadAsInactive] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Upsert project configurations

        Parameters
        ----------
        id : str

        timeout_to_mark_thread_as_inactive : typing.Optional[ConfigurationTimeoutToMarkThreadAsInactive]
            minimum precision supported is seconds, please use a duration with seconds precision or higher. Also, the max duration allowed is 7 days.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.projects.upsert_project_configurations(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.upsert_project_configurations(
            id, timeout_to_mark_thread_as_inactive=timeout_to_mark_thread_as_inactive, request_options=request_options
        )
        return _response.data
