# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.json_node_write import JsonNodeWrite
from ..types.prompt_detail import PromptDetail
from ..types.prompt_page_public import PromptPagePublic
from ..types.prompt_version_detail import PromptVersionDetail
from ..types.prompt_version_page_public import PromptVersionPagePublic
from .raw_client import AsyncRawPromptsClient, RawPromptsClient
from .types.prompt_write_type import PromptWriteType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PromptsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPromptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPromptsClient
        """
        return self._raw_client

    def get_prompts(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptPagePublic:
        """
        Get prompts

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptPagePublic
            OK

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.get_prompts()
        """
        _response = self._raw_client.get_prompts(page=page, size=size, name=name, request_options=request_options)
        return _response.data

    def create_prompt(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        template: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonNodeWrite] = OMIT,
        change_description: typing.Optional[str] = OMIT,
        type: typing.Optional[PromptWriteType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create prompt

        Parameters
        ----------
        name : str

        id : typing.Optional[str]

        description : typing.Optional[str]

        template : typing.Optional[str]

        metadata : typing.Optional[JsonNodeWrite]

        change_description : typing.Optional[str]

        type : typing.Optional[PromptWriteType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.create_prompt(name='name', )
        """
        _response = self._raw_client.create_prompt(
            name=name,
            id=id,
            description=description,
            template=template,
            metadata=metadata,
            change_description=change_description,
            type=type,
            request_options=request_options,
        )
        return _response.data

    def create_prompt_version(
        self, *, name: str, version: PromptVersionDetail, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptVersionDetail:
        """
        Create prompt version

        Parameters
        ----------
        name : str

        version : PromptVersionDetail

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionDetail
            OK

        Examples
        --------
        from Opik import OpikApi
        from Opik import PromptVersionDetail
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.create_prompt_version(name='name', version=PromptVersionDetail(template='template', ), )
        """
        _response = self._raw_client.create_prompt_version(name=name, version=version, request_options=request_options)
        return _response.data

    def get_prompt_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> PromptDetail:
        """
        Get prompt by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptDetail
            Prompt resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.get_prompt_by_id(id='id', )
        """
        _response = self._raw_client.get_prompt_by_id(id, request_options=request_options)
        return _response.data

    def update_prompt(
        self,
        id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update prompt

        Parameters
        ----------
        id : str

        name : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.update_prompt(id='id', name='name', )
        """
        _response = self._raw_client.update_prompt(
            id, name=name, description=description, request_options=request_options
        )
        return _response.data

    def delete_prompt(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete prompt

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.delete_prompt(id='id', )
        """
        _response = self._raw_client.delete_prompt(id, request_options=request_options)
        return _response.data

    def delete_prompts_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete prompts batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.delete_prompts_batch(ids=['ids'], )
        """
        _response = self._raw_client.delete_prompts_batch(ids=ids, request_options=request_options)
        return _response.data

    def get_prompt_version_by_id(
        self, version_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptVersionDetail:
        """
        Get prompt version by id

        Parameters
        ----------
        version_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionDetail
            Prompt version resource

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.get_prompt_version_by_id(version_id='versionId', )
        """
        _response = self._raw_client.get_prompt_version_by_id(version_id, request_options=request_options)
        return _response.data

    def get_prompt_versions(
        self,
        id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptVersionPagePublic:
        """
        Get prompt versions

        Parameters
        ----------
        id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionPagePublic
            OK

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.get_prompt_versions(id='id', )
        """
        _response = self._raw_client.get_prompt_versions(id, page=page, size=size, request_options=request_options)
        return _response.data

    def retrieve_prompt_version(
        self, *, name: str, commit: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptVersionDetail:
        """
        Retrieve prompt version

        Parameters
        ----------
        name : str

        commit : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionDetail
            OK

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.prompts.retrieve_prompt_version(name='name', )
        """
        _response = self._raw_client.retrieve_prompt_version(name=name, commit=commit, request_options=request_options)
        return _response.data


class AsyncPromptsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPromptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPromptsClient
        """
        return self._raw_client

    async def get_prompts(
        self,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptPagePublic:
        """
        Get prompts

        Parameters
        ----------
        page : typing.Optional[int]

        size : typing.Optional[int]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptPagePublic
            OK

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.get_prompts()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_prompts(page=page, size=size, name=name, request_options=request_options)
        return _response.data

    async def create_prompt(
        self,
        *,
        name: str,
        id: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        template: typing.Optional[str] = OMIT,
        metadata: typing.Optional[JsonNodeWrite] = OMIT,
        change_description: typing.Optional[str] = OMIT,
        type: typing.Optional[PromptWriteType] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create prompt

        Parameters
        ----------
        name : str

        id : typing.Optional[str]

        description : typing.Optional[str]

        template : typing.Optional[str]

        metadata : typing.Optional[JsonNodeWrite]

        change_description : typing.Optional[str]

        type : typing.Optional[PromptWriteType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.create_prompt(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_prompt(
            name=name,
            id=id,
            description=description,
            template=template,
            metadata=metadata,
            change_description=change_description,
            type=type,
            request_options=request_options,
        )
        return _response.data

    async def create_prompt_version(
        self, *, name: str, version: PromptVersionDetail, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptVersionDetail:
        """
        Create prompt version

        Parameters
        ----------
        name : str

        version : PromptVersionDetail

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionDetail
            OK

        Examples
        --------
        from Opik import AsyncOpikApi
        from Opik import PromptVersionDetail
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.create_prompt_version(name='name', version=PromptVersionDetail(template='template', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_prompt_version(
            name=name, version=version, request_options=request_options
        )
        return _response.data

    async def get_prompt_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptDetail:
        """
        Get prompt by id

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptDetail
            Prompt resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.get_prompt_by_id(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_prompt_by_id(id, request_options=request_options)
        return _response.data

    async def update_prompt(
        self,
        id: str,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update prompt

        Parameters
        ----------
        id : str

        name : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.update_prompt(id='id', name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_prompt(
            id, name=name, description=description, request_options=request_options
        )
        return _response.data

    async def delete_prompt(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete prompt

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.delete_prompt(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_prompt(id, request_options=request_options)
        return _response.data

    async def delete_prompts_batch(
        self, *, ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete prompts batch

        Parameters
        ----------
        ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.delete_prompts_batch(ids=['ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_prompts_batch(ids=ids, request_options=request_options)
        return _response.data

    async def get_prompt_version_by_id(
        self, version_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptVersionDetail:
        """
        Get prompt version by id

        Parameters
        ----------
        version_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionDetail
            Prompt version resource

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.get_prompt_version_by_id(version_id='versionId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_prompt_version_by_id(version_id, request_options=request_options)
        return _response.data

    async def get_prompt_versions(
        self,
        id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptVersionPagePublic:
        """
        Get prompt versions

        Parameters
        ----------
        id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionPagePublic
            OK

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.get_prompt_versions(id='id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_prompt_versions(
            id, page=page, size=size, request_options=request_options
        )
        return _response.data

    async def retrieve_prompt_version(
        self, *, name: str, commit: typing.Optional[str] = OMIT, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptVersionDetail:
        """
        Retrieve prompt version

        Parameters
        ----------
        name : str

        commit : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptVersionDetail
            OK

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.prompts.retrieve_prompt_version(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_prompt_version(
            name=name, commit=commit, request_options=request_options
        )
        return _response.data
