# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .json_node import JsonNode
from .prompt_type import PromptType
from .prompt_version import PromptVersion


class Prompt(UniversalBaseModel):
    id: typing.Optional[str] = None
    name: str
    description: typing.Optional[str] = None
    template: typing.Optional[str] = None
    metadata: typing.Optional[JsonNode] = None
    change_description: typing.Optional[str] = None
    type: typing.Optional[PromptType] = None
    created_at: typing.Optional[dt.datetime] = None
    created_by: typing.Optional[str] = None
    last_updated_at: typing.Optional[dt.datetime] = None
    last_updated_by: typing.Optional[str] = None
    version_count: typing.Optional[int] = None
    latest_version: typing.Optional[PromptVersion] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
