# -*- coding: utf-8 -*-
#
# Copyright (C) 2023 CERN.
#
# Invenio-Notifications is free software; you can redistribute it and/or
# modify it under the terms of the MIT License; see LICENSE file for more
# details.

"""Module tests."""

from flask import Flask

from invenio_notifications import InvenioNotifications


def test_version():
    """Test version import."""
    from invenio_notifications import __version__

    assert __version__


def test_init():
    """Test extension initialization."""
    app = Flask("testapp")
    ext = InvenioNotifications(app)
    assert "invenio-notifications" in app.extensions

    app = Flask("testapp")
    ext = InvenioNotifications()
    assert "invenio-notifications" not in app.extensions
    ext.init_app(app)
    assert "invenio-notifications" in app.extensions
