# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from datetime import datetime

from pydantic import StrictInt, StrictStr, field_validator

from typing import Optional

from rcabench.openapi.models.dto_generic_response_dto_analyze_injections_resp import DtoGenericResponseDtoAnalyzeInjectionsResp

from rcabench.openapi.api_client import ApiClient
from rcabench.openapi.api_response import ApiResponse
from rcabench.openapi.rest import RESTResponseType


class AnalyzerApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://rcabench.openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_v1_analyzers_injections_get(
        self,
        project_name: Annotated[Optional[StrictStr], Field(description="Project name filter")] = None,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Classification label filter")] = None,
        benchmark: Annotated[Optional[StrictStr], Field(description="Benchmark type filter")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Status filter, refer to field mapping interface (/mapping) for specific values")] = None,
        fault_type: Annotated[Optional[StrictInt], Field(description="Fault type filter, refer to field mapping interface (/mapping) for specific values")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default is not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoAnalyzeInjectionsResp:
        """Analyze fault injection data

        Analyze fault injection data using various filtering conditions, returning statistical information including efficiency, diversity, distance between seeds, etc.

        :param project_name: Project name filter
        :type project_name: str
        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param tag: Classification label filter
        :type tag: str
        :param benchmark: Benchmark type filter
        :type benchmark: str
        :param status: Status filter, refer to field mapping interface (/mapping) for specific values
        :type status: int
        :param fault_type: Fault type filter, refer to field mapping interface (/mapping) for specific values
        :type fault_type: int
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default is not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_analyzers_injections_get_serialize(
            project_name=project_name,
            env=env,
            batch=batch,
            tag=tag,
            benchmark=benchmark,
            status=status,
            fault_type=fault_type,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoAnalyzeInjectionsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_analyzers_injections_get_with_http_info(
        self,
        project_name: Annotated[Optional[StrictStr], Field(description="Project name filter")] = None,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Classification label filter")] = None,
        benchmark: Annotated[Optional[StrictStr], Field(description="Benchmark type filter")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Status filter, refer to field mapping interface (/mapping) for specific values")] = None,
        fault_type: Annotated[Optional[StrictInt], Field(description="Fault type filter, refer to field mapping interface (/mapping) for specific values")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default is not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoAnalyzeInjectionsResp]:
        """Analyze fault injection data

        Analyze fault injection data using various filtering conditions, returning statistical information including efficiency, diversity, distance between seeds, etc.

        :param project_name: Project name filter
        :type project_name: str
        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param tag: Classification label filter
        :type tag: str
        :param benchmark: Benchmark type filter
        :type benchmark: str
        :param status: Status filter, refer to field mapping interface (/mapping) for specific values
        :type status: int
        :param fault_type: Fault type filter, refer to field mapping interface (/mapping) for specific values
        :type fault_type: int
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default is not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_analyzers_injections_get_serialize(
            project_name=project_name,
            env=env,
            batch=batch,
            tag=tag,
            benchmark=benchmark,
            status=status,
            fault_type=fault_type,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoAnalyzeInjectionsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_analyzers_injections_get_without_preload_content(
        self,
        project_name: Annotated[Optional[StrictStr], Field(description="Project name filter")] = None,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Classification label filter")] = None,
        benchmark: Annotated[Optional[StrictStr], Field(description="Benchmark type filter")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Status filter, refer to field mapping interface (/mapping) for specific values")] = None,
        fault_type: Annotated[Optional[StrictInt], Field(description="Fault type filter, refer to field mapping interface (/mapping) for specific values")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default is not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Analyze fault injection data

        Analyze fault injection data using various filtering conditions, returning statistical information including efficiency, diversity, distance between seeds, etc.

        :param project_name: Project name filter
        :type project_name: str
        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param tag: Classification label filter
        :type tag: str
        :param benchmark: Benchmark type filter
        :type benchmark: str
        :param status: Status filter, refer to field mapping interface (/mapping) for specific values
        :type status: int
        :param fault_type: Fault type filter, refer to field mapping interface (/mapping) for specific values
        :type fault_type: int
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default is not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_analyzers_injections_get_serialize(
            project_name=project_name,
            env=env,
            batch=batch,
            tag=tag,
            benchmark=benchmark,
            status=status,
            fault_type=fault_type,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoAnalyzeInjectionsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_analyzers_injections_get_serialize(
        self,
        project_name,
        env,
        batch,
        tag,
        benchmark,
        status,
        fault_type,
        lookback,
        custom_start_time,
        custom_end_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if project_name is not None:
            
            _query_params.append(('project_name', project_name))
            
        if env is not None:
            
            _query_params.append(('env', env))
            
        if batch is not None:
            
            _query_params.append(('batch', batch))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if benchmark is not None:
            
            _query_params.append(('benchmark', benchmark))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if fault_type is not None:
            
            _query_params.append(('fault_type', fault_type))
            
        if lookback is not None:
            
            _query_params.append(('lookback', lookback))
            
        if custom_start_time is not None:
            if isinstance(custom_start_time, datetime):
                _query_params.append(
                    (
                        'custom_start_time',
                        custom_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_start_time', custom_start_time))
            
        if custom_end_time is not None:
            if isinstance(custom_end_time, datetime):
                _query_params.append(
                    (
                        'custom_end_time',
                        custom_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_end_time', custom_end_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/analyzers/injections',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


