# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from pydantic import StrictBool, StrictBytes, StrictStr, field_validator

from typing import List, Optional, Union

from rcabench.openapi.models.dto_generic_response_dto_submit_resp import DtoGenericResponseDtoSubmitResp

from rcabench.openapi.api_client import ApiClient
from rcabench.openapi.api_response import ApiResponse
from rcabench.openapi.rest import RESTResponseType


class ContainerApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://rcabench.openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_v1_containers_post(
        self,
        image: Annotated[StrictStr, Field(description="Docker image name. When source_type is harbor, specify the existing image name in Harbor; otherwise, supports the following formats: 1) image-name (automatically adds default Harbor address and namespace) 2) namespace/image-name (automatically adds default Harbor address)")],
        type: Annotated[Optional[StrictStr], Field(description="Container type, specifies the purpose of the container")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Container name, used to identify the container, will be used as the image build identifier, defaults to the name field in info.toml")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Docker image tag. When source_type is harbor, specify the existing image tag in Harbor; otherwise, used for version control")] = None,
        command: Annotated[Optional[StrictStr], Field(description="Docker image startup command, defaults to bash /entrypoint.sh")] = None,
        env_vars: Annotated[Optional[List[StrictStr]], Field(description="List of environment variable names, supports multiple variables")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="Build source type, specifies the source of the code")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Source file (supports zip or tar.gz format), required when source_type is file, file size limit 5MB")] = None,
        github_token: Annotated[Optional[StrictStr], Field(description="GitHub access token, used for private repositories, not required for public repositories")] = None,
        github_repo: Annotated[Optional[StrictStr], Field(description="GitHub repository address, format: owner/repo, required when source_type is github")] = None,
        github_branch: Annotated[Optional[StrictStr], Field(description="GitHub branch name, specifies the branch to build")] = None,
        github_commit: Annotated[Optional[StrictStr], Field(description="GitHub commit hash (supports short hash), if specified, branch parameter is ignored")] = None,
        github_path: Annotated[Optional[StrictStr], Field(description="Subdirectory path in the repository, if the source code is not in the root directory")] = None,
        context_dir: Annotated[Optional[StrictStr], Field(description="Docker build context path, relative to the source root directory")] = None,
        dockerfile_path: Annotated[Optional[StrictStr], Field(description="Dockerfile path, relative to the source root directory")] = None,
        target: Annotated[Optional[StrictStr], Field(description="Dockerfile build target (used for multi-stage builds)")] = None,
        force_rebuild: Annotated[Optional[StrictBool], Field(description="Whether to force rebuild the image, ignore cache")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoSubmitResp:
        """Submit container build task

        Build Docker images by uploading files, specifying GitHub repositories, or Harbor images. Supports zip and tar.gz file uploads, or automatically pulls code from GitHub for building, or directly updates the database from existing Harbor images. The system automatically validates required files (Dockerfile) and sets execution permissions.

        :param image: Docker image name. When source_type is harbor, specify the existing image name in Harbor; otherwise, supports the following formats: 1) image-name (automatically adds default Harbor address and namespace) 2) namespace/image-name (automatically adds default Harbor address) (required)
        :type image: str
        :param type: Container type, specifies the purpose of the container
        :type type: str
        :param name: Container name, used to identify the container, will be used as the image build identifier, defaults to the name field in info.toml
        :type name: str
        :param tag: Docker image tag. When source_type is harbor, specify the existing image tag in Harbor; otherwise, used for version control
        :type tag: str
        :param command: Docker image startup command, defaults to bash /entrypoint.sh
        :type command: str
        :param env_vars: List of environment variable names, supports multiple variables
        :type env_vars: List[str]
        :param source_type: Build source type, specifies the source of the code
        :type source_type: str
        :param file: Source file (supports zip or tar.gz format), required when source_type is file, file size limit 5MB
        :type file: bytearray
        :param github_token: GitHub access token, used for private repositories, not required for public repositories
        :type github_token: str
        :param github_repo: GitHub repository address, format: owner/repo, required when source_type is github
        :type github_repo: str
        :param github_branch: GitHub branch name, specifies the branch to build
        :type github_branch: str
        :param github_commit: GitHub commit hash (supports short hash), if specified, branch parameter is ignored
        :type github_commit: str
        :param github_path: Subdirectory path in the repository, if the source code is not in the root directory
        :type github_path: str
        :param context_dir: Docker build context path, relative to the source root directory
        :type context_dir: str
        :param dockerfile_path: Dockerfile path, relative to the source root directory
        :type dockerfile_path: str
        :param target: Dockerfile build target (used for multi-stage builds)
        :type target: str
        :param force_rebuild: Whether to force rebuild the image, ignore cache
        :type force_rebuild: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_containers_post_serialize(
            image=image,
            type=type,
            name=name,
            tag=tag,
            command=command,
            env_vars=env_vars,
            source_type=source_type,
            file=file,
            github_token=github_token,
            github_repo=github_repo,
            github_branch=github_branch,
            github_commit=github_commit,
            github_path=github_path,
            context_dir=context_dir,
            dockerfile_path=dockerfile_path,
            target=target,
            force_rebuild=force_rebuild,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_containers_post_with_http_info(
        self,
        image: Annotated[StrictStr, Field(description="Docker image name. When source_type is harbor, specify the existing image name in Harbor; otherwise, supports the following formats: 1) image-name (automatically adds default Harbor address and namespace) 2) namespace/image-name (automatically adds default Harbor address)")],
        type: Annotated[Optional[StrictStr], Field(description="Container type, specifies the purpose of the container")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Container name, used to identify the container, will be used as the image build identifier, defaults to the name field in info.toml")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Docker image tag. When source_type is harbor, specify the existing image tag in Harbor; otherwise, used for version control")] = None,
        command: Annotated[Optional[StrictStr], Field(description="Docker image startup command, defaults to bash /entrypoint.sh")] = None,
        env_vars: Annotated[Optional[List[StrictStr]], Field(description="List of environment variable names, supports multiple variables")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="Build source type, specifies the source of the code")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Source file (supports zip or tar.gz format), required when source_type is file, file size limit 5MB")] = None,
        github_token: Annotated[Optional[StrictStr], Field(description="GitHub access token, used for private repositories, not required for public repositories")] = None,
        github_repo: Annotated[Optional[StrictStr], Field(description="GitHub repository address, format: owner/repo, required when source_type is github")] = None,
        github_branch: Annotated[Optional[StrictStr], Field(description="GitHub branch name, specifies the branch to build")] = None,
        github_commit: Annotated[Optional[StrictStr], Field(description="GitHub commit hash (supports short hash), if specified, branch parameter is ignored")] = None,
        github_path: Annotated[Optional[StrictStr], Field(description="Subdirectory path in the repository, if the source code is not in the root directory")] = None,
        context_dir: Annotated[Optional[StrictStr], Field(description="Docker build context path, relative to the source root directory")] = None,
        dockerfile_path: Annotated[Optional[StrictStr], Field(description="Dockerfile path, relative to the source root directory")] = None,
        target: Annotated[Optional[StrictStr], Field(description="Dockerfile build target (used for multi-stage builds)")] = None,
        force_rebuild: Annotated[Optional[StrictBool], Field(description="Whether to force rebuild the image, ignore cache")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoSubmitResp]:
        """Submit container build task

        Build Docker images by uploading files, specifying GitHub repositories, or Harbor images. Supports zip and tar.gz file uploads, or automatically pulls code from GitHub for building, or directly updates the database from existing Harbor images. The system automatically validates required files (Dockerfile) and sets execution permissions.

        :param image: Docker image name. When source_type is harbor, specify the existing image name in Harbor; otherwise, supports the following formats: 1) image-name (automatically adds default Harbor address and namespace) 2) namespace/image-name (automatically adds default Harbor address) (required)
        :type image: str
        :param type: Container type, specifies the purpose of the container
        :type type: str
        :param name: Container name, used to identify the container, will be used as the image build identifier, defaults to the name field in info.toml
        :type name: str
        :param tag: Docker image tag. When source_type is harbor, specify the existing image tag in Harbor; otherwise, used for version control
        :type tag: str
        :param command: Docker image startup command, defaults to bash /entrypoint.sh
        :type command: str
        :param env_vars: List of environment variable names, supports multiple variables
        :type env_vars: List[str]
        :param source_type: Build source type, specifies the source of the code
        :type source_type: str
        :param file: Source file (supports zip or tar.gz format), required when source_type is file, file size limit 5MB
        :type file: bytearray
        :param github_token: GitHub access token, used for private repositories, not required for public repositories
        :type github_token: str
        :param github_repo: GitHub repository address, format: owner/repo, required when source_type is github
        :type github_repo: str
        :param github_branch: GitHub branch name, specifies the branch to build
        :type github_branch: str
        :param github_commit: GitHub commit hash (supports short hash), if specified, branch parameter is ignored
        :type github_commit: str
        :param github_path: Subdirectory path in the repository, if the source code is not in the root directory
        :type github_path: str
        :param context_dir: Docker build context path, relative to the source root directory
        :type context_dir: str
        :param dockerfile_path: Dockerfile path, relative to the source root directory
        :type dockerfile_path: str
        :param target: Dockerfile build target (used for multi-stage builds)
        :type target: str
        :param force_rebuild: Whether to force rebuild the image, ignore cache
        :type force_rebuild: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_containers_post_serialize(
            image=image,
            type=type,
            name=name,
            tag=tag,
            command=command,
            env_vars=env_vars,
            source_type=source_type,
            file=file,
            github_token=github_token,
            github_repo=github_repo,
            github_branch=github_branch,
            github_commit=github_commit,
            github_path=github_path,
            context_dir=context_dir,
            dockerfile_path=dockerfile_path,
            target=target,
            force_rebuild=force_rebuild,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_containers_post_without_preload_content(
        self,
        image: Annotated[StrictStr, Field(description="Docker image name. When source_type is harbor, specify the existing image name in Harbor; otherwise, supports the following formats: 1) image-name (automatically adds default Harbor address and namespace) 2) namespace/image-name (automatically adds default Harbor address)")],
        type: Annotated[Optional[StrictStr], Field(description="Container type, specifies the purpose of the container")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Container name, used to identify the container, will be used as the image build identifier, defaults to the name field in info.toml")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Docker image tag. When source_type is harbor, specify the existing image tag in Harbor; otherwise, used for version control")] = None,
        command: Annotated[Optional[StrictStr], Field(description="Docker image startup command, defaults to bash /entrypoint.sh")] = None,
        env_vars: Annotated[Optional[List[StrictStr]], Field(description="List of environment variable names, supports multiple variables")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="Build source type, specifies the source of the code")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr]], Field(description="Source file (supports zip or tar.gz format), required when source_type is file, file size limit 5MB")] = None,
        github_token: Annotated[Optional[StrictStr], Field(description="GitHub access token, used for private repositories, not required for public repositories")] = None,
        github_repo: Annotated[Optional[StrictStr], Field(description="GitHub repository address, format: owner/repo, required when source_type is github")] = None,
        github_branch: Annotated[Optional[StrictStr], Field(description="GitHub branch name, specifies the branch to build")] = None,
        github_commit: Annotated[Optional[StrictStr], Field(description="GitHub commit hash (supports short hash), if specified, branch parameter is ignored")] = None,
        github_path: Annotated[Optional[StrictStr], Field(description="Subdirectory path in the repository, if the source code is not in the root directory")] = None,
        context_dir: Annotated[Optional[StrictStr], Field(description="Docker build context path, relative to the source root directory")] = None,
        dockerfile_path: Annotated[Optional[StrictStr], Field(description="Dockerfile path, relative to the source root directory")] = None,
        target: Annotated[Optional[StrictStr], Field(description="Dockerfile build target (used for multi-stage builds)")] = None,
        force_rebuild: Annotated[Optional[StrictBool], Field(description="Whether to force rebuild the image, ignore cache")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Submit container build task

        Build Docker images by uploading files, specifying GitHub repositories, or Harbor images. Supports zip and tar.gz file uploads, or automatically pulls code from GitHub for building, or directly updates the database from existing Harbor images. The system automatically validates required files (Dockerfile) and sets execution permissions.

        :param image: Docker image name. When source_type is harbor, specify the existing image name in Harbor; otherwise, supports the following formats: 1) image-name (automatically adds default Harbor address and namespace) 2) namespace/image-name (automatically adds default Harbor address) (required)
        :type image: str
        :param type: Container type, specifies the purpose of the container
        :type type: str
        :param name: Container name, used to identify the container, will be used as the image build identifier, defaults to the name field in info.toml
        :type name: str
        :param tag: Docker image tag. When source_type is harbor, specify the existing image tag in Harbor; otherwise, used for version control
        :type tag: str
        :param command: Docker image startup command, defaults to bash /entrypoint.sh
        :type command: str
        :param env_vars: List of environment variable names, supports multiple variables
        :type env_vars: List[str]
        :param source_type: Build source type, specifies the source of the code
        :type source_type: str
        :param file: Source file (supports zip or tar.gz format), required when source_type is file, file size limit 5MB
        :type file: bytearray
        :param github_token: GitHub access token, used for private repositories, not required for public repositories
        :type github_token: str
        :param github_repo: GitHub repository address, format: owner/repo, required when source_type is github
        :type github_repo: str
        :param github_branch: GitHub branch name, specifies the branch to build
        :type github_branch: str
        :param github_commit: GitHub commit hash (supports short hash), if specified, branch parameter is ignored
        :type github_commit: str
        :param github_path: Subdirectory path in the repository, if the source code is not in the root directory
        :type github_path: str
        :param context_dir: Docker build context path, relative to the source root directory
        :type context_dir: str
        :param dockerfile_path: Dockerfile path, relative to the source root directory
        :type dockerfile_path: str
        :param target: Dockerfile build target (used for multi-stage builds)
        :type target: str
        :param force_rebuild: Whether to force rebuild the image, ignore cache
        :type force_rebuild: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_containers_post_serialize(
            image=image,
            type=type,
            name=name,
            tag=tag,
            command=command,
            env_vars=env_vars,
            source_type=source_type,
            file=file,
            github_token=github_token,
            github_repo=github_repo,
            github_branch=github_branch,
            github_commit=github_commit,
            github_path=github_path,
            context_dir=context_dir,
            dockerfile_path=dockerfile_path,
            target=target,
            force_rebuild=force_rebuild,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_containers_post_serialize(
        self,
        image,
        type,
        name,
        tag,
        command,
        env_vars,
        source_type,
        file,
        github_token,
        github_repo,
        github_branch,
        github_commit,
        github_path,
        context_dir,
        dockerfile_path,
        target,
        force_rebuild,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            'env_vars': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if type is not None:
            _form_params.append(('type', type))
        if name is not None:
            _form_params.append(('name', name))
        if image is not None:
            _form_params.append(('image', image))
        if tag is not None:
            _form_params.append(('tag', tag))
        if command is not None:
            _form_params.append(('command', command))
        if env_vars is not None:
            _form_params.append(('env_vars', env_vars))
        if source_type is not None:
            _form_params.append(('source_type', source_type))
        if file is not None:
            _files['file'] = file
        if github_token is not None:
            _form_params.append(('github_token', github_token))
        if github_repo is not None:
            _form_params.append(('github_repo', github_repo))
        if github_branch is not None:
            _form_params.append(('github_branch', github_branch))
        if github_commit is not None:
            _form_params.append(('github_commit', github_commit))
        if github_path is not None:
            _form_params.append(('github_path', github_path))
        if context_dir is not None:
            _form_params.append(('context_dir', context_dir))
        if dockerfile_path is not None:
            _form_params.append(('dockerfile_path', dockerfile_path))
        if target is not None:
            _form_params.append(('target', target))
        if force_rebuild is not None:
            _form_params.append(('force_rebuild', force_rebuild))
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/containers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


