# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from datetime import datetime

from pydantic import StrictInt, StrictStr, field_validator

from typing import List, Optional

from rcabench.openapi.models.dto_generic_response_any import DtoGenericResponseAny
from rcabench.openapi.models.dto_generic_response_array_dto_fault_injection_no_issues_resp import DtoGenericResponseArrayDtoFaultInjectionNoIssuesResp
from rcabench.openapi.models.dto_generic_response_array_dto_fault_injection_with_issues_resp import DtoGenericResponseArrayDtoFaultInjectionWithIssuesResp
from rcabench.openapi.models.dto_generic_response_dto_inject_cancel_resp import DtoGenericResponseDtoInjectCancelResp
from rcabench.openapi.models.dto_generic_response_dto_injection_field_mapping_resp import DtoGenericResponseDtoInjectionFieldMappingResp
from rcabench.openapi.models.dto_generic_response_dto_injection_stats_resp import DtoGenericResponseDtoInjectionStatsResp
from rcabench.openapi.models.dto_generic_response_dto_list_injections_resp import DtoGenericResponseDtoListInjectionsResp
from rcabench.openapi.models.dto_generic_response_dto_query_injection_resp import DtoGenericResponseDtoQueryInjectionResp
from rcabench.openapi.models.dto_generic_response_dto_submit_injection_resp import DtoGenericResponseDtoSubmitInjectionResp
from rcabench.openapi.models.dto_generic_response_handler_node import DtoGenericResponseHandlerNode
from rcabench.openapi.models.dto_generic_response_handler_resources import DtoGenericResponseHandlerResources
from rcabench.openapi.models.dto_submit_injection_req import DtoSubmitInjectionReq

from rcabench.openapi.api_client import ApiClient
from rcabench.openapi.api_response import ApiResponse
from rcabench.openapi.rest import RESTResponseType


class InjectionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://rcabench.openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_v1_injections_analysis_no_issues_get(
        self,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseArrayDtoFaultInjectionNoIssuesResp:
        """Query Fault Injection Records Without Issues

        Query all fault injection records without issues based on time range, returning detailed records including configuration information

        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_no_issues_get_serialize(
            env=env,
            batch=batch,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseArrayDtoFaultInjectionNoIssuesResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_analysis_no_issues_get_with_http_info(
        self,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseArrayDtoFaultInjectionNoIssuesResp]:
        """Query Fault Injection Records Without Issues

        Query all fault injection records without issues based on time range, returning detailed records including configuration information

        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_no_issues_get_serialize(
            env=env,
            batch=batch,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseArrayDtoFaultInjectionNoIssuesResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_analysis_no_issues_get_without_preload_content(
        self,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Query Fault Injection Records Without Issues

        Query all fault injection records without issues based on time range, returning detailed records including configuration information

        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_no_issues_get_serialize(
            env=env,
            batch=batch,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseArrayDtoFaultInjectionNoIssuesResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_analysis_no_issues_get_serialize(
        self,
        env,
        batch,
        lookback,
        custom_start_time,
        custom_end_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if env is not None:
            
            _query_params.append(('env', env))
            
        if batch is not None:
            
            _query_params.append(('batch', batch))
            
        if lookback is not None:
            
            _query_params.append(('lookback', lookback))
            
        if custom_start_time is not None:
            if isinstance(custom_start_time, datetime):
                _query_params.append(
                    (
                        'custom_start_time',
                        custom_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_start_time', custom_start_time))
            
        if custom_end_time is not None:
            if isinstance(custom_end_time, datetime):
                _query_params.append(
                    (
                        'custom_end_time',
                        custom_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_end_time', custom_end_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/analysis/no-issues',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_analysis_stats_get(
        self,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoInjectionStatsResp:
        """Get Fault Injection Statistics

        Get statistical information of fault injection records, including counts of records with issues, without issues, and total records

        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_stats_get_serialize(
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectionStatsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_analysis_stats_get_with_http_info(
        self,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoInjectionStatsResp]:
        """Get Fault Injection Statistics

        Get statistical information of fault injection records, including counts of records with issues, without issues, and total records

        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_stats_get_serialize(
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectionStatsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_analysis_stats_get_without_preload_content(
        self,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Fault Injection Statistics

        Get statistical information of fault injection records, including counts of records with issues, without issues, and total records

        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_stats_get_serialize(
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectionStatsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_analysis_stats_get_serialize(
        self,
        lookback,
        custom_start_time,
        custom_end_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if lookback is not None:
            
            _query_params.append(('lookback', lookback))
            
        if custom_start_time is not None:
            if isinstance(custom_start_time, datetime):
                _query_params.append(
                    (
                        'custom_start_time',
                        custom_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_start_time', custom_start_time))
            
        if custom_end_time is not None:
            if isinstance(custom_end_time, datetime):
                _query_params.append(
                    (
                        'custom_end_time',
                        custom_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_end_time', custom_end_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/analysis/stats',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_analysis_with_issues_get(
        self,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseArrayDtoFaultInjectionWithIssuesResp:
        """Query Fault Injection Records With Issues

        Query all fault injection records with issues based on time range

        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_with_issues_get_serialize(
            env=env,
            batch=batch,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseArrayDtoFaultInjectionWithIssuesResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_analysis_with_issues_get_with_http_info(
        self,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseArrayDtoFaultInjectionWithIssuesResp]:
        """Query Fault Injection Records With Issues

        Query all fault injection records with issues based on time range

        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_with_issues_get_serialize(
            env=env,
            batch=batch,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseArrayDtoFaultInjectionWithIssuesResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_analysis_with_issues_get_without_preload_content(
        self,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Query Fault Injection Records With Issues

        Query all fault injection records with issues based on time range

        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_analysis_with_issues_get_serialize(
            env=env,
            batch=batch,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseArrayDtoFaultInjectionWithIssuesResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_analysis_with_issues_get_serialize(
        self,
        env,
        batch,
        lookback,
        custom_start_time,
        custom_end_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if env is not None:
            
            _query_params.append(('env', env))
            
        if batch is not None:
            
            _query_params.append(('batch', batch))
            
        if lookback is not None:
            
            _query_params.append(('lookback', lookback))
            
        if custom_start_time is not None:
            if isinstance(custom_start_time, datetime):
                _query_params.append(
                    (
                        'custom_start_time',
                        custom_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_start_time', custom_start_time))
            
        if custom_end_time is not None:
            if isinstance(custom_end_time, datetime):
                _query_params.append(
                    (
                        'custom_end_time',
                        custom_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_end_time', custom_end_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/analysis/with-issues',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_conf_get(
        self,
        namespace: Annotated[StrictStr, Field(description="Namespace, specifies the namespace to get configuration for")],
        mode: Annotated[Optional[StrictStr], Field(description="Display mode")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseHandlerNode:
        """Get Fault Injection Configuration

        Get fault injection configuration for the specified namespace, supporting different display modes for configuration tree structure

        :param namespace: Namespace, specifies the namespace to get configuration for (required)
        :type namespace: str
        :param mode: Display mode
        :type mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_conf_get_serialize(
            namespace=namespace,
            mode=mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseHandlerNode",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_conf_get_with_http_info(
        self,
        namespace: Annotated[StrictStr, Field(description="Namespace, specifies the namespace to get configuration for")],
        mode: Annotated[Optional[StrictStr], Field(description="Display mode")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseHandlerNode]:
        """Get Fault Injection Configuration

        Get fault injection configuration for the specified namespace, supporting different display modes for configuration tree structure

        :param namespace: Namespace, specifies the namespace to get configuration for (required)
        :type namespace: str
        :param mode: Display mode
        :type mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_conf_get_serialize(
            namespace=namespace,
            mode=mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseHandlerNode",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_conf_get_without_preload_content(
        self,
        namespace: Annotated[StrictStr, Field(description="Namespace, specifies the namespace to get configuration for")],
        mode: Annotated[Optional[StrictStr], Field(description="Display mode")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Fault Injection Configuration

        Get fault injection configuration for the specified namespace, supporting different display modes for configuration tree structure

        :param namespace: Namespace, specifies the namespace to get configuration for (required)
        :type namespace: str
        :param mode: Display mode
        :type mode: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_conf_get_serialize(
            namespace=namespace,
            mode=mode,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseHandlerNode",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_conf_get_serialize(
        self,
        namespace,
        mode,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if namespace is not None:
            
            _query_params.append(('namespace', namespace))
            
        if mode is not None:
            
            _query_params.append(('mode', mode))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/conf',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_configs_get(
        self,
        trace_ids: Annotated[Optional[List[StrictStr]], Field(description="TraceID list, supports multiple values, used to query corresponding configuration information")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseAny:
        """Get Injected Fault Configuration List

        Get fault injection configuration information based on multiple TraceIDs, used to view configuration details of submitted fault injection tasks

        :param trace_ids: TraceID list, supports multiple values, used to query corresponding configuration information
        :type trace_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_configs_get_serialize(
            trace_ids=trace_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseAny",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_configs_get_with_http_info(
        self,
        trace_ids: Annotated[Optional[List[StrictStr]], Field(description="TraceID list, supports multiple values, used to query corresponding configuration information")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseAny]:
        """Get Injected Fault Configuration List

        Get fault injection configuration information based on multiple TraceIDs, used to view configuration details of submitted fault injection tasks

        :param trace_ids: TraceID list, supports multiple values, used to query corresponding configuration information
        :type trace_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_configs_get_serialize(
            trace_ids=trace_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseAny",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_configs_get_without_preload_content(
        self,
        trace_ids: Annotated[Optional[List[StrictStr]], Field(description="TraceID list, supports multiple values, used to query corresponding configuration information")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Injected Fault Configuration List

        Get fault injection configuration information based on multiple TraceIDs, used to view configuration details of submitted fault injection tasks

        :param trace_ids: TraceID list, supports multiple values, used to query corresponding configuration information
        :type trace_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_configs_get_serialize(
            trace_ids=trace_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseAny",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_configs_get_serialize(
        self,
        trace_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
            'trace_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if trace_ids is not None:
            
            _query_params.append(('trace_ids', trace_ids))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/configs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_get(
        self,
        project_name: Annotated[Optional[StrictStr], Field(description="Project name filter")] = None,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Category label filter")] = None,
        benchmark: Annotated[Optional[StrictStr], Field(description="Benchmark type filter")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Status filter, refer to field mapping interface (/mapping) for specific values")] = None,
        fault_type: Annotated[Optional[StrictInt], Field(description="Fault type filter, refer to field mapping interface (/mapping) for specific values")] = None,
        sort_field: Annotated[Optional[StrictStr], Field(description="Sort field, default created_at")] = None,
        sort_order: Annotated[Optional[StrictStr], Field(description="Sort order, default desc")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Result quantity limit, used to control the number of returned records")] = None,
        page_num: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Pagination query, page number")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Pagination query, records per page")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoListInjectionsResp:
        """Get Fault Injection Record List

        Fault injection record query interface supporting sorting and filtering. Returns the original database record list without data conversion.

        :param project_name: Project name filter
        :type project_name: str
        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param tag: Category label filter
        :type tag: str
        :param benchmark: Benchmark type filter
        :type benchmark: str
        :param status: Status filter, refer to field mapping interface (/mapping) for specific values
        :type status: int
        :param fault_type: Fault type filter, refer to field mapping interface (/mapping) for specific values
        :type fault_type: int
        :param sort_field: Sort field, default created_at
        :type sort_field: str
        :param sort_order: Sort order, default desc
        :type sort_order: str
        :param limit: Result quantity limit, used to control the number of returned records
        :type limit: int
        :param page_num: Pagination query, page number
        :type page_num: int
        :param page_size: Pagination query, records per page
        :type page_size: int
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_get_serialize(
            project_name=project_name,
            env=env,
            batch=batch,
            tag=tag,
            benchmark=benchmark,
            status=status,
            fault_type=fault_type,
            sort_field=sort_field,
            sort_order=sort_order,
            limit=limit,
            page_num=page_num,
            page_size=page_size,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListInjectionsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_get_with_http_info(
        self,
        project_name: Annotated[Optional[StrictStr], Field(description="Project name filter")] = None,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Category label filter")] = None,
        benchmark: Annotated[Optional[StrictStr], Field(description="Benchmark type filter")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Status filter, refer to field mapping interface (/mapping) for specific values")] = None,
        fault_type: Annotated[Optional[StrictInt], Field(description="Fault type filter, refer to field mapping interface (/mapping) for specific values")] = None,
        sort_field: Annotated[Optional[StrictStr], Field(description="Sort field, default created_at")] = None,
        sort_order: Annotated[Optional[StrictStr], Field(description="Sort order, default desc")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Result quantity limit, used to control the number of returned records")] = None,
        page_num: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Pagination query, page number")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Pagination query, records per page")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoListInjectionsResp]:
        """Get Fault Injection Record List

        Fault injection record query interface supporting sorting and filtering. Returns the original database record list without data conversion.

        :param project_name: Project name filter
        :type project_name: str
        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param tag: Category label filter
        :type tag: str
        :param benchmark: Benchmark type filter
        :type benchmark: str
        :param status: Status filter, refer to field mapping interface (/mapping) for specific values
        :type status: int
        :param fault_type: Fault type filter, refer to field mapping interface (/mapping) for specific values
        :type fault_type: int
        :param sort_field: Sort field, default created_at
        :type sort_field: str
        :param sort_order: Sort order, default desc
        :type sort_order: str
        :param limit: Result quantity limit, used to control the number of returned records
        :type limit: int
        :param page_num: Pagination query, page number
        :type page_num: int
        :param page_size: Pagination query, records per page
        :type page_size: int
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_get_serialize(
            project_name=project_name,
            env=env,
            batch=batch,
            tag=tag,
            benchmark=benchmark,
            status=status,
            fault_type=fault_type,
            sort_field=sort_field,
            sort_order=sort_order,
            limit=limit,
            page_num=page_num,
            page_size=page_size,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListInjectionsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_get_without_preload_content(
        self,
        project_name: Annotated[Optional[StrictStr], Field(description="Project name filter")] = None,
        env: Annotated[Optional[StrictStr], Field(description="Environment label filter")] = None,
        batch: Annotated[Optional[StrictStr], Field(description="Batch label filter")] = None,
        tag: Annotated[Optional[StrictStr], Field(description="Category label filter")] = None,
        benchmark: Annotated[Optional[StrictStr], Field(description="Benchmark type filter")] = None,
        status: Annotated[Optional[StrictInt], Field(description="Status filter, refer to field mapping interface (/mapping) for specific values")] = None,
        fault_type: Annotated[Optional[StrictInt], Field(description="Fault type filter, refer to field mapping interface (/mapping) for specific values")] = None,
        sort_field: Annotated[Optional[StrictStr], Field(description="Sort field, default created_at")] = None,
        sort_order: Annotated[Optional[StrictStr], Field(description="Sort order, default desc")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Result quantity limit, used to control the number of returned records")] = None,
        page_num: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Pagination query, page number")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Pagination query, records per page")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports custom relative time (1h/24h/7d) or custom, default not set")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required when lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required when lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Fault Injection Record List

        Fault injection record query interface supporting sorting and filtering. Returns the original database record list without data conversion.

        :param project_name: Project name filter
        :type project_name: str
        :param env: Environment label filter
        :type env: str
        :param batch: Batch label filter
        :type batch: str
        :param tag: Category label filter
        :type tag: str
        :param benchmark: Benchmark type filter
        :type benchmark: str
        :param status: Status filter, refer to field mapping interface (/mapping) for specific values
        :type status: int
        :param fault_type: Fault type filter, refer to field mapping interface (/mapping) for specific values
        :type fault_type: int
        :param sort_field: Sort field, default created_at
        :type sort_field: str
        :param sort_order: Sort order, default desc
        :type sort_order: str
        :param limit: Result quantity limit, used to control the number of returned records
        :type limit: int
        :param page_num: Pagination query, page number
        :type page_num: int
        :param page_size: Pagination query, records per page
        :type page_size: int
        :param lookback: Time range query, supports custom relative time (1h/24h/7d) or custom, default not set
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required when lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required when lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_get_serialize(
            project_name=project_name,
            env=env,
            batch=batch,
            tag=tag,
            benchmark=benchmark,
            status=status,
            fault_type=fault_type,
            sort_field=sort_field,
            sort_order=sort_order,
            limit=limit,
            page_num=page_num,
            page_size=page_size,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListInjectionsResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_get_serialize(
        self,
        project_name,
        env,
        batch,
        tag,
        benchmark,
        status,
        fault_type,
        sort_field,
        sort_order,
        limit,
        page_num,
        page_size,
        lookback,
        custom_start_time,
        custom_end_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if project_name is not None:
            
            _query_params.append(('project_name', project_name))
            
        if env is not None:
            
            _query_params.append(('env', env))
            
        if batch is not None:
            
            _query_params.append(('batch', batch))
            
        if tag is not None:
            
            _query_params.append(('tag', tag))
            
        if benchmark is not None:
            
            _query_params.append(('benchmark', benchmark))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if fault_type is not None:
            
            _query_params.append(('fault_type', fault_type))
            
        if sort_field is not None:
            
            _query_params.append(('sort_field', sort_field))
            
        if sort_order is not None:
            
            _query_params.append(('sort_order', sort_order))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if page_num is not None:
            
            _query_params.append(('page_num', page_num))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if lookback is not None:
            
            _query_params.append(('lookback', lookback))
            
        if custom_start_time is not None:
            if isinstance(custom_start_time, datetime):
                _query_params.append(
                    (
                        'custom_start_time',
                        custom_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_start_time', custom_start_time))
            
        if custom_end_time is not None:
            if isinstance(custom_end_time, datetime):
                _query_params.append(
                    (
                        'custom_end_time',
                        custom_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_end_time', custom_end_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_mapping_get(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoInjectionFieldMappingResp:
        """Get Field Mapping

        Get string-to-number mapping relationships for status and fault types, used for frontend display and API parameter validation

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_mapping_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectionFieldMappingResp",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_mapping_get_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoInjectionFieldMappingResp]:
        """Get Field Mapping

        Get string-to-number mapping relationships for status and fault types, used for frontend display and API parameter validation

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_mapping_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectionFieldMappingResp",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_mapping_get_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Field Mapping

        Get string-to-number mapping relationships for status and fault types, used for frontend display and API parameter validation

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_mapping_get_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectionFieldMappingResp",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_mapping_get_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/mapping',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_ns_resources_get(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace name, returns resource mappings for all namespaces if not specified")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseHandlerResources:
        """Get Namespace Resource Mapping

        Get mapping of all namespaces and their corresponding resource information, or query resource information for a specific namespace. Returns a mapping table from namespace to resources, used for fault injection configuration and resource management

        :param namespace: Namespace name, returns resource mappings for all namespaces if not specified
        :type namespace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_ns_resources_get_serialize(
            namespace=namespace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseHandlerResources",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_ns_resources_get_with_http_info(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace name, returns resource mappings for all namespaces if not specified")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseHandlerResources]:
        """Get Namespace Resource Mapping

        Get mapping of all namespaces and their corresponding resource information, or query resource information for a specific namespace. Returns a mapping table from namespace to resources, used for fault injection configuration and resource management

        :param namespace: Namespace name, returns resource mappings for all namespaces if not specified
        :type namespace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_ns_resources_get_serialize(
            namespace=namespace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseHandlerResources",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_ns_resources_get_without_preload_content(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace name, returns resource mappings for all namespaces if not specified")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Namespace Resource Mapping

        Get mapping of all namespaces and their corresponding resource information, or query resource information for a specific namespace. Returns a mapping table from namespace to resources, used for fault injection configuration and resource management

        :param namespace: Namespace name, returns resource mappings for all namespaces if not specified
        :type namespace: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_ns_resources_get_serialize(
            namespace=namespace,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseHandlerResources",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_ns_resources_get_serialize(
        self,
        namespace,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if namespace is not None:
            
            _query_params.append(('namespace', namespace))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/ns-resources',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_post(
        self,
        body: Annotated[DtoSubmitInjectionReq, Field(description="Fault injection request body")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoSubmitInjectionResp:
        """Submit Fault Injection Task

        Submit fault injection task, supporting batch submission of multiple fault configurations, the system will automatically deduplicate and return submission results

        :param body: Fault injection request body (required)
        :type body: DtoSubmitInjectionReq
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_post_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitInjectionResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_post_with_http_info(
        self,
        body: Annotated[DtoSubmitInjectionReq, Field(description="Fault injection request body")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoSubmitInjectionResp]:
        """Submit Fault Injection Task

        Submit fault injection task, supporting batch submission of multiple fault configurations, the system will automatically deduplicate and return submission results

        :param body: Fault injection request body (required)
        :type body: DtoSubmitInjectionReq
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_post_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitInjectionResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_post_without_preload_content(
        self,
        body: Annotated[DtoSubmitInjectionReq, Field(description="Fault injection request body")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Submit Fault Injection Task

        Submit fault injection task, supporting batch submission of multiple fault configurations, the system will automatically deduplicate and return submission results

        :param body: Fault injection request body (required)
        :type body: DtoSubmitInjectionReq
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_post_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "DtoGenericResponseDtoSubmitInjectionResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_post_serialize(
        self,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/injections',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_query_get(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Fault injection name")] = None,
        task_id: Annotated[Optional[StrictStr], Field(description="Task ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoQueryInjectionResp:
        """Query Single Fault Injection Record

        Query fault injection record details by name or task ID, at least one of the two parameters must be provided

        :param name: Fault injection name
        :type name: str
        :param task_id: Task ID
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_query_get_serialize(
            name=name,
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoQueryInjectionResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_query_get_with_http_info(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Fault injection name")] = None,
        task_id: Annotated[Optional[StrictStr], Field(description="Task ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoQueryInjectionResp]:
        """Query Single Fault Injection Record

        Query fault injection record details by name or task ID, at least one of the two parameters must be provided

        :param name: Fault injection name
        :type name: str
        :param task_id: Task ID
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_query_get_serialize(
            name=name,
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoQueryInjectionResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_query_get_without_preload_content(
        self,
        name: Annotated[Optional[StrictStr], Field(description="Fault injection name")] = None,
        task_id: Annotated[Optional[StrictStr], Field(description="Task ID")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Query Single Fault Injection Record

        Query fault injection record details by name or task ID, at least one of the two parameters must be provided

        :param name: Fault injection name
        :type name: str
        :param task_id: Task ID
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_query_get_serialize(
            name=name,
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoQueryInjectionResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_query_get_serialize(
        self,
        name,
        task_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:
            
            _query_params.append(('name', name))
            
        if task_id is not None:
            
            _query_params.append(('task_id', task_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/injections/query',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_injections_task_id_cancel_put(
        self,
        task_id: Annotated[StrictStr, Field(description="Task ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoInjectCancelResp:
        """Cancel Fault Injection Task

        Cancel the specified fault injection task

        :param task_id: Task ID (required)
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_task_id_cancel_put_serialize(
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectCancelResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_injections_task_id_cancel_put_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="Task ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoInjectCancelResp]:
        """Cancel Fault Injection Task

        Cancel the specified fault injection task

        :param task_id: Task ID (required)
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_task_id_cancel_put_serialize(
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectCancelResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_injections_task_id_cancel_put_without_preload_content(
        self,
        task_id: Annotated[StrictStr, Field(description="Task ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Cancel Fault Injection Task

        Cancel the specified fault injection task

        :param task_id: Task ID (required)
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_injections_task_id_cancel_put_serialize(
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoInjectCancelResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_injections_task_id_cancel_put_serialize(
        self,
        task_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_id is not None:
            _path_params['task_id'] = task_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/api/v1/injections/{task_id}/cancel',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


