# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import Field
from typing_extensions import Annotated
from datetime import datetime

from pydantic import StrictBool, StrictInt, StrictStr, field_validator

from typing import Optional

from rcabench.openapi.models.dto_generic_response_dto_list_tasks_resp import DtoGenericResponseDtoListTasksResp
from rcabench.openapi.models.dto_generic_response_dto_pagination_resp_dto_unified_task import DtoGenericResponseDtoPaginationRespDtoUnifiedTask
from rcabench.openapi.models.dto_generic_response_dto_task_detail_resp import DtoGenericResponseDtoTaskDetailResp

from rcabench.openapi.api_client import ApiClient
from rcabench.openapi.api_response import ApiResponse
from rcabench.openapi.rest import RESTResponseType


class TaskApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://rcabench.openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def api_v1_tasks_get(
        self,
        task_id: Annotated[Optional[StrictStr], Field(description="Task ID - exact match (mutually exclusive with trace_id, group_id)")] = None,
        trace_id: Annotated[Optional[StrictStr], Field(description="Trace ID - find all tasks in the same trace (mutually exclusive with task_id, group_id)")] = None,
        group_id: Annotated[Optional[StrictStr], Field(description="Group ID - find all tasks in the same group (mutually exclusive with task_id, trace_id)")] = None,
        task_type: Annotated[Optional[StrictStr], Field(description="Task type filter")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Task status filter")] = None,
        immediate: Annotated[Optional[StrictBool], Field(description="Immediate execution - true: immediate, false: delayed")] = None,
        sort_field: Annotated[Optional[StrictStr], Field(description="Sort field, default created_at")] = None,
        sort_order: Annotated[Optional[StrictStr], Field(description="Sort order, default desc")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Result limit, controls number of records returned")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports relative time (1h/24h/7d) or custom, default unset")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required if lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required if lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoListTasksResp:
        """Get task list

        Paginate and get task list by multiple conditions. Supports exact query by task ID, trace ID, group ID, or filter by type, status, etc.

        :param task_id: Task ID - exact match (mutually exclusive with trace_id, group_id)
        :type task_id: str
        :param trace_id: Trace ID - find all tasks in the same trace (mutually exclusive with task_id, group_id)
        :type trace_id: str
        :param group_id: Group ID - find all tasks in the same group (mutually exclusive with task_id, trace_id)
        :type group_id: str
        :param task_type: Task type filter
        :type task_type: str
        :param status: Task status filter
        :type status: str
        :param immediate: Immediate execution - true: immediate, false: delayed
        :type immediate: bool
        :param sort_field: Sort field, default created_at
        :type sort_field: str
        :param sort_order: Sort order, default desc
        :type sort_order: str
        :param limit: Result limit, controls number of records returned
        :type limit: int
        :param lookback: Time range query, supports relative time (1h/24h/7d) or custom, default unset
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required if lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required if lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_get_serialize(
            task_id=task_id,
            trace_id=trace_id,
            group_id=group_id,
            task_type=task_type,
            status=status,
            immediate=immediate,
            sort_field=sort_field,
            sort_order=sort_order,
            limit=limit,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListTasksResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_tasks_get_with_http_info(
        self,
        task_id: Annotated[Optional[StrictStr], Field(description="Task ID - exact match (mutually exclusive with trace_id, group_id)")] = None,
        trace_id: Annotated[Optional[StrictStr], Field(description="Trace ID - find all tasks in the same trace (mutually exclusive with task_id, group_id)")] = None,
        group_id: Annotated[Optional[StrictStr], Field(description="Group ID - find all tasks in the same group (mutually exclusive with task_id, trace_id)")] = None,
        task_type: Annotated[Optional[StrictStr], Field(description="Task type filter")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Task status filter")] = None,
        immediate: Annotated[Optional[StrictBool], Field(description="Immediate execution - true: immediate, false: delayed")] = None,
        sort_field: Annotated[Optional[StrictStr], Field(description="Sort field, default created_at")] = None,
        sort_order: Annotated[Optional[StrictStr], Field(description="Sort order, default desc")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Result limit, controls number of records returned")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports relative time (1h/24h/7d) or custom, default unset")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required if lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required if lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoListTasksResp]:
        """Get task list

        Paginate and get task list by multiple conditions. Supports exact query by task ID, trace ID, group ID, or filter by type, status, etc.

        :param task_id: Task ID - exact match (mutually exclusive with trace_id, group_id)
        :type task_id: str
        :param trace_id: Trace ID - find all tasks in the same trace (mutually exclusive with task_id, group_id)
        :type trace_id: str
        :param group_id: Group ID - find all tasks in the same group (mutually exclusive with task_id, trace_id)
        :type group_id: str
        :param task_type: Task type filter
        :type task_type: str
        :param status: Task status filter
        :type status: str
        :param immediate: Immediate execution - true: immediate, false: delayed
        :type immediate: bool
        :param sort_field: Sort field, default created_at
        :type sort_field: str
        :param sort_order: Sort order, default desc
        :type sort_order: str
        :param limit: Result limit, controls number of records returned
        :type limit: int
        :param lookback: Time range query, supports relative time (1h/24h/7d) or custom, default unset
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required if lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required if lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_get_serialize(
            task_id=task_id,
            trace_id=trace_id,
            group_id=group_id,
            task_type=task_type,
            status=status,
            immediate=immediate,
            sort_field=sort_field,
            sort_order=sort_order,
            limit=limit,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListTasksResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_tasks_get_without_preload_content(
        self,
        task_id: Annotated[Optional[StrictStr], Field(description="Task ID - exact match (mutually exclusive with trace_id, group_id)")] = None,
        trace_id: Annotated[Optional[StrictStr], Field(description="Trace ID - find all tasks in the same trace (mutually exclusive with task_id, group_id)")] = None,
        group_id: Annotated[Optional[StrictStr], Field(description="Group ID - find all tasks in the same group (mutually exclusive with task_id, trace_id)")] = None,
        task_type: Annotated[Optional[StrictStr], Field(description="Task type filter")] = None,
        status: Annotated[Optional[StrictStr], Field(description="Task status filter")] = None,
        immediate: Annotated[Optional[StrictBool], Field(description="Immediate execution - true: immediate, false: delayed")] = None,
        sort_field: Annotated[Optional[StrictStr], Field(description="Sort field, default created_at")] = None,
        sort_order: Annotated[Optional[StrictStr], Field(description="Sort order, default desc")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Result limit, controls number of records returned")] = None,
        lookback: Annotated[Optional[StrictStr], Field(description="Time range query, supports relative time (1h/24h/7d) or custom, default unset")] = None,
        custom_start_time: Annotated[Optional[datetime], Field(description="Custom start time, RFC3339 format, required if lookback=custom")] = None,
        custom_end_time: Annotated[Optional[datetime], Field(description="Custom end time, RFC3339 format, required if lookback=custom")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get task list

        Paginate and get task list by multiple conditions. Supports exact query by task ID, trace ID, group ID, or filter by type, status, etc.

        :param task_id: Task ID - exact match (mutually exclusive with trace_id, group_id)
        :type task_id: str
        :param trace_id: Trace ID - find all tasks in the same trace (mutually exclusive with task_id, group_id)
        :type trace_id: str
        :param group_id: Group ID - find all tasks in the same group (mutually exclusive with task_id, trace_id)
        :type group_id: str
        :param task_type: Task type filter
        :type task_type: str
        :param status: Task status filter
        :type status: str
        :param immediate: Immediate execution - true: immediate, false: delayed
        :type immediate: bool
        :param sort_field: Sort field, default created_at
        :type sort_field: str
        :param sort_order: Sort order, default desc
        :type sort_order: str
        :param limit: Result limit, controls number of records returned
        :type limit: int
        :param lookback: Time range query, supports relative time (1h/24h/7d) or custom, default unset
        :type lookback: str
        :param custom_start_time: Custom start time, RFC3339 format, required if lookback=custom
        :type custom_start_time: datetime
        :param custom_end_time: Custom end time, RFC3339 format, required if lookback=custom
        :type custom_end_time: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_get_serialize(
            task_id=task_id,
            trace_id=trace_id,
            group_id=group_id,
            task_type=task_type,
            status=status,
            immediate=immediate,
            sort_field=sort_field,
            sort_order=sort_order,
            limit=limit,
            lookback=lookback,
            custom_start_time=custom_start_time,
            custom_end_time=custom_end_time,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoListTasksResp",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_tasks_get_serialize(
        self,
        task_id,
        trace_id,
        group_id,
        task_type,
        status,
        immediate,
        sort_field,
        sort_order,
        limit,
        lookback,
        custom_start_time,
        custom_end_time,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if task_id is not None:
            
            _query_params.append(('task_id', task_id))
            
        if trace_id is not None:
            
            _query_params.append(('trace_id', trace_id))
            
        if group_id is not None:
            
            _query_params.append(('group_id', group_id))
            
        if task_type is not None:
            
            _query_params.append(('task_type', task_type))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if immediate is not None:
            
            _query_params.append(('immediate', immediate))
            
        if sort_field is not None:
            
            _query_params.append(('sort_field', sort_field))
            
        if sort_order is not None:
            
            _query_params.append(('sort_order', sort_order))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if lookback is not None:
            
            _query_params.append(('lookback', lookback))
            
        if custom_start_time is not None:
            if isinstance(custom_start_time, datetime):
                _query_params.append(
                    (
                        'custom_start_time',
                        custom_start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_start_time', custom_start_time))
            
        if custom_end_time is not None:
            if isinstance(custom_end_time, datetime):
                _query_params.append(
                    (
                        'custom_end_time',
                        custom_end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('custom_end_time', custom_end_time))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/tasks',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_tasks_queue_get(
        self,
        page_num: Annotated[Optional[StrictInt], Field(description="Page number")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoPaginationRespDtoUnifiedTask:
        """Get queued tasks

        Paginate and get the list of tasks waiting in the queue

        :param page_num: Page number
        :type page_num: int
        :param page_size: Page size
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_queue_get_serialize(
            page_num=page_num,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoPaginationRespDtoUnifiedTask",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_tasks_queue_get_with_http_info(
        self,
        page_num: Annotated[Optional[StrictInt], Field(description="Page number")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoPaginationRespDtoUnifiedTask]:
        """Get queued tasks

        Paginate and get the list of tasks waiting in the queue

        :param page_num: Page number
        :type page_num: int
        :param page_size: Page size
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_queue_get_serialize(
            page_num=page_num,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoPaginationRespDtoUnifiedTask",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_tasks_queue_get_without_preload_content(
        self,
        page_num: Annotated[Optional[StrictInt], Field(description="Page number")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Page size")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get queued tasks

        Paginate and get the list of tasks waiting in the queue

        :param page_num: Page number
        :type page_num: int
        :param page_size: Page size
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_queue_get_serialize(
            page_num=page_num,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoPaginationRespDtoUnifiedTask",
            '400': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_tasks_queue_get_serialize(
        self,
        page_num,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page_num is not None:
            
            _query_params.append(('page_num', page_num))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/tasks/queue',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def api_v1_tasks_task_id_get(
        self,
        task_id: Annotated[StrictStr, Field(description="Task ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DtoGenericResponseDtoTaskDetailResp:
        """Get task detail

        Get detailed information of a task by task ID, including basic info and execution logs

        :param task_id: Task ID (required)
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_task_id_get_serialize(
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoTaskDetailResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def api_v1_tasks_task_id_get_with_http_info(
        self,
        task_id: Annotated[StrictStr, Field(description="Task ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DtoGenericResponseDtoTaskDetailResp]:
        """Get task detail

        Get detailed information of a task by task ID, including basic info and execution logs

        :param task_id: Task ID (required)
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_task_id_get_serialize(
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoTaskDetailResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def api_v1_tasks_task_id_get_without_preload_content(
        self,
        task_id: Annotated[StrictStr, Field(description="Task ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get task detail

        Get detailed information of a task by task ID, including basic info and execution logs

        :param task_id: Task ID (required)
        :type task_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._api_v1_tasks_task_id_get_serialize(
            task_id=task_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DtoGenericResponseDtoTaskDetailResp",
            '400': "DtoGenericResponseAny",
            '404': "DtoGenericResponseAny",
            '500': "DtoGenericResponseAny",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _api_v1_tasks_task_id_get_serialize(
        self,
        task_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if task_id is not None:
            _path_params['task_id'] = task_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/tasks/{task_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


