# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from rcabench.openapi.models.database_fault_injection_schedule import DatabaseFaultInjectionSchedule
from rcabench.openapi.models.database_label import DatabaseLabel
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DatabaseDataset(BaseModel):
    """
    DatabaseDataset
    """ # noqa: E501
    checksum: Optional[StrictStr] = Field(default=None, description="File checksum")
    created_at: Optional[StrictStr] = Field(default=None, description="Creation time")
    data_source: Optional[StrictStr] = Field(default=None, description="Data source description")
    dataset_version: Optional[StrictStr] = Field(default=None, description="Dataset version with size limit")
    description: Optional[StrictStr] = Field(default=None, description="Dataset description")
    download_url: Optional[StrictStr] = Field(default=None, description="Download link with size limit")
    fault_injections: Optional[List[DatabaseFaultInjectionSchedule]] = None
    file_count: Optional[StrictInt] = Field(default=None, description="File count with validation")
    format: Optional[StrictStr] = Field(default=None, description="Data format (json, csv, parquet, etc.)")
    id: Optional[StrictInt] = Field(default=None, description="Unique identifier")
    is_public: Optional[StrictBool] = Field(default=None, description="Whether public")
    labels: Optional[List[DatabaseLabel]] = Field(default=None, description="Many-to-many relationships - use explicit intermediate tables for better control")
    name: Optional[StrictStr] = Field(default=None, description="Dataset name with size limit")
    status: Optional[StrictInt] = Field(default=None, description="Status: -1:deleted 0:disabled 1:enabled")
    type: Optional[StrictStr] = Field(default=None, description="Dataset type (e.g., \"microservice\", \"database\", \"network\")")
    updated_at: Optional[StrictStr] = Field(default=None, description="Update time")
    __properties: ClassVar[List[str]] = ["checksum", "created_at", "data_source", "dataset_version", "description", "download_url", "fault_injections", "file_count", "format", "id", "is_public", "labels", "name", "status", "type", "updated_at"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DatabaseDataset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fault_injections (list)
        _items = []
        if self.fault_injections:
            for _item in self.fault_injections:
                if _item:
                    _items.append(_item.to_dict())
            _dict['fault_injections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item in self.labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['labels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DatabaseDataset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "checksum": obj.get("checksum"),
            "created_at": obj.get("created_at"),
            "data_source": obj.get("data_source"),
            "dataset_version": obj.get("dataset_version"),
            "description": obj.get("description"),
            "download_url": obj.get("download_url"),
            "fault_injections": [DatabaseFaultInjectionSchedule.from_dict(_item) for _item in obj.get("fault_injections")] if obj.get("fault_injections") is not None else None,
            "file_count": obj.get("file_count"),
            "format": obj.get("format"),
            "id": obj.get("id"),
            "is_public": obj.get("is_public"),
            "labels": [DatabaseLabel.from_dict(_item) for _item in obj.get("labels")] if obj.get("labels") is not None else None,
            "name": obj.get("name"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


