# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from rcabench.openapi.models.dto_granularity_record import DtoGranularityRecord
from rcabench.openapi.models.handler_groundtruth import HandlerGroundtruth
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoAlgorithmDatapackEvaluationResp(BaseModel):
    """
    DtoAlgorithmDatapackEvaluationResp
    """ # noqa: E501
    algorithm: Optional[StrictStr] = Field(default=None, description="Algorithm name")
    datapack: Optional[StrictStr] = Field(default=None, description="Datapack name")
    executed_at: Optional[StrictStr] = Field(default=None, description="Execution time")
    execution_id: Optional[StrictInt] = Field(default=None, description="Execution ID (0 if no execution found)")
    found: Optional[StrictBool] = Field(default=None, description="Whether execution result was found")
    groundtruth: Optional[HandlerGroundtruth] = None
    predictions: Optional[List[DtoGranularityRecord]] = Field(default=None, description="Algorithm predictions")
    __properties: ClassVar[List[str]] = ["algorithm", "datapack", "executed_at", "execution_id", "found", "groundtruth", "predictions"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoAlgorithmDatapackEvaluationResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of groundtruth
        if self.groundtruth:
            _dict['groundtruth'] = self.groundtruth.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in predictions (list)
        _items = []
        if self.predictions:
            for _item in self.predictions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['predictions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoAlgorithmDatapackEvaluationResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "algorithm": obj.get("algorithm"),
            "datapack": obj.get("datapack"),
            "executed_at": obj.get("executed_at"),
            "execution_id": obj.get("execution_id"),
            "found": obj.get("found"),
            "groundtruth": HandlerGroundtruth.from_dict(obj.get("groundtruth")) if obj.get("groundtruth") is not None else None,
            "predictions": [DtoGranularityRecord.from_dict(_item) for _item in obj.get("predictions")] if obj.get("predictions") is not None else None
        })
        return _obj


