# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from rcabench.openapi.models.dto_injection_stats import DtoInjectionStats
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoAnalyzeInjectionsResp(BaseModel):
    """
    DtoAnalyzeInjectionsResp
    """ # noqa: E501
    efficiency: Optional[StrictStr] = None
    stats: Optional[Dict[str, DtoInjectionStats]] = None
    __properties: ClassVar[List[str]] = ["efficiency", "stats"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoAnalyzeInjectionsResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in stats (dict)
        _field_dict = {}
        if self.stats:
            for _key in self.stats:
                if self.stats[_key]:
                    _field_dict[_key] = self.stats[_key].to_dict()
            _dict['stats'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoAnalyzeInjectionsResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "efficiency": obj.get("efficiency"),
            "stats": dict(
                (_k, DtoInjectionStats.from_dict(_v))
                for _k, _v in obj.get("stats").items()
            )
            if obj.get("stats") is not None
            else None
        })
        return _obj


