# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoAuditLogResponse(BaseModel):
    """
    DtoAuditLogResponse
    """ # noqa: E501
    action: Optional[StrictStr] = None
    details: Optional[StrictStr] = None
    error: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    ip_address: Optional[StrictStr] = None
    resource: Optional[StrictStr] = None
    resource_id: Optional[StrictStr] = None
    success: Optional[StrictBool] = None
    timestamp: Optional[StrictStr] = None
    user_agent: Optional[StrictStr] = None
    user_id: Optional[StrictInt] = None
    username: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["action", "details", "error", "id", "ip_address", "resource", "resource_id", "success", "timestamp", "user_agent", "user_id", "username"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoAuditLogResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoAuditLogResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "action": obj.get("action"),
            "details": obj.get("details"),
            "error": obj.get("error"),
            "id": obj.get("id"),
            "ip_address": obj.get("ip_address"),
            "resource": obj.get("resource"),
            "resource_id": obj.get("resource_id"),
            "success": obj.get("success"),
            "timestamp": obj.get("timestamp"),
            "user_agent": obj.get("user_agent"),
            "user_id": obj.get("user_id"),
            "username": obj.get("username")
        })
        return _obj


