# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from rcabench.openapi.models.dto_user_response import DtoUserResponse
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoContainerResponse(BaseModel):
    """
    DtoContainerResponse
    """ # noqa: E501
    command: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    env_vars: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    image: Optional[StrictStr] = None
    is_public: Optional[StrictBool] = None
    name: Optional[StrictStr] = None
    status: Optional[StrictInt] = None
    tag: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    user: Optional[DtoUserResponse] = None
    user_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["command", "created_at", "env_vars", "id", "image", "is_public", "name", "status", "tag", "type", "updated_at", "user", "user_id"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoContainerResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoContainerResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "command": obj.get("command"),
            "created_at": obj.get("created_at"),
            "env_vars": obj.get("env_vars"),
            "id": obj.get("id"),
            "image": obj.get("image"),
            "is_public": obj.get("is_public"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "tag": obj.get("tag"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at"),
            "user": DtoUserResponse.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "user_id": obj.get("user_id")
        })
        return _obj


