# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt
from pydantic import Field
from rcabench.openapi.models.dto_datapack_detector_item import DtoDatapackDetectorItem
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoDatapackDetectorResp(BaseModel):
    """
    DtoDatapackDetectorResp
    """ # noqa: E501
    found_count: Optional[StrictInt] = Field(default=None, description="Number of datapacks with detector results")
    items: Optional[List[DtoDatapackDetectorItem]] = Field(default=None, description="Detector results for each datapack")
    not_found_count: Optional[StrictInt] = Field(default=None, description="Number of datapacks without detector results")
    total_count: Optional[StrictInt] = Field(default=None, description="Total number of requested datapacks")
    __properties: ClassVar[List[str]] = ["found_count", "items", "not_found_count", "total_count"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoDatapackDetectorResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoDatapackDetectorResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "found_count": obj.get("found_count"),
            "items": [DtoDatapackDetectorItem.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None,
            "not_found_count": obj.get("not_found_count"),
            "total_count": obj.get("total_count")
        })
        return _obj


