# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from rcabench.openapi.models.database_label import DatabaseLabel
from rcabench.openapi.models.dto_injection_v2_response import DtoInjectionV2Response
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoDatasetV2Response(BaseModel):
    """
    DtoDatasetV2Response
    """ # noqa: E501
    checksum: Optional[StrictStr] = Field(default=None, description="File checksum")
    created_at: Optional[StrictStr] = Field(default=None, description="Creation time")
    data_source: Optional[StrictStr] = Field(default=None, description="Data source description")
    description: Optional[StrictStr] = Field(default=None, description="Dataset description")
    download_url: Optional[StrictStr] = Field(default=None, description="Download URL")
    file_count: Optional[StrictInt] = Field(default=None, description="File count")
    format: Optional[StrictStr] = Field(default=None, description="Data format")
    id: Optional[StrictInt] = Field(default=None, description="Unique identifier")
    injections: Optional[List[DtoInjectionV2Response]] = Field(default=None, description="Associated fault injections")
    is_public: Optional[StrictBool] = Field(default=None, description="Whether public")
    labels: Optional[List[DatabaseLabel]] = Field(default=None, description="Associated labels")
    name: Optional[StrictStr] = Field(default=None, description="Dataset name")
    status: Optional[StrictInt] = Field(default=None, description="Status")
    type: Optional[StrictStr] = Field(default=None, description="Dataset type")
    updated_at: Optional[StrictStr] = Field(default=None, description="Update time")
    version: Optional[StrictStr] = Field(default=None, description="Dataset version")
    __properties: ClassVar[List[str]] = ["checksum", "created_at", "data_source", "description", "download_url", "file_count", "format", "id", "injections", "is_public", "labels", "name", "status", "type", "updated_at", "version"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoDatasetV2Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in injections (list)
        _items = []
        if self.injections:
            for _item in self.injections:
                if _item:
                    _items.append(_item.to_dict())
            _dict['injections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item in self.labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['labels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoDatasetV2Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "checksum": obj.get("checksum"),
            "created_at": obj.get("created_at"),
            "data_source": obj.get("data_source"),
            "description": obj.get("description"),
            "download_url": obj.get("download_url"),
            "file_count": obj.get("file_count"),
            "format": obj.get("format"),
            "id": obj.get("id"),
            "injections": [DtoInjectionV2Response.from_dict(_item) for _item in obj.get("injections")] if obj.get("injections") is not None else None,
            "is_public": obj.get("is_public"),
            "labels": [DatabaseLabel.from_dict(_item) for _item in obj.get("labels")] if obj.get("labels") is not None else None,
            "name": obj.get("name"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at"),
            "version": obj.get("version")
        })
        return _obj


