# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from typing_extensions import Annotated
from rcabench.openapi.models.dto_date_range_filter import DtoDateRangeFilter
from rcabench.openapi.models.dto_size_range_filter import DtoSizeRangeFilter
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoDatasetV2SearchReq(BaseModel):
    """
    DtoDatasetV2SearchReq
    """ # noqa: E501
    date_range: Optional[DtoDateRangeFilter] = None
    include: Optional[List[StrictStr]] = Field(default=None, description="Included related data")
    is_public: Optional[StrictBool] = Field(default=None, description="Whether public")
    label_keys: Optional[List[StrictStr]] = Field(default=None, description="Filter by label key")
    label_values: Optional[List[StrictStr]] = Field(default=None, description="Filter by label value")
    page: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, description="Page number")
    search: Optional[StrictStr] = Field(default=None, description="Search keywords")
    size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = Field(default=None, description="Page size")
    size_range: Optional[DtoSizeRangeFilter] = None
    sort_by: Optional[StrictStr] = Field(default=None, description="Sort field")
    sort_order: Optional[StrictStr] = Field(default=None, description="Sort direction")
    statuses: Optional[List[StrictInt]] = Field(default=None, description="Status list")
    types: Optional[List[StrictStr]] = Field(default=None, description="Dataset type list")
    __properties: ClassVar[List[str]] = ["date_range", "include", "is_public", "label_keys", "label_values", "page", "search", "size", "size_range", "sort_by", "sort_order", "statuses", "types"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoDatasetV2SearchReq from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of date_range
        if self.date_range:
            _dict['date_range'] = self.date_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of size_range
        if self.size_range:
            _dict['size_range'] = self.size_range.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoDatasetV2SearchReq from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date_range": DtoDateRangeFilter.from_dict(obj.get("date_range")) if obj.get("date_range") is not None else None,
            "include": obj.get("include"),
            "is_public": obj.get("is_public"),
            "label_keys": obj.get("label_keys"),
            "label_values": obj.get("label_values"),
            "page": obj.get("page"),
            "search": obj.get("search"),
            "size": obj.get("size"),
            "size_range": DtoSizeRangeFilter.from_dict(obj.get("size_range")) if obj.get("size_range") is not None else None,
            "sort_by": obj.get("sort_by"),
            "sort_order": obj.get("sort_order"),
            "statuses": obj.get("statuses"),
            "types": obj.get("types")
        })
        return _obj


