# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt
from pydantic import Field
from typing_extensions import Annotated
from rcabench.openapi.models.dto_dataset_v2_label_create_req import DtoDatasetV2LabelCreateReq
from rcabench.openapi.models.dto_injection_ref import DtoInjectionRef
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoDatasetV2UpdateReq(BaseModel):
    """
    DtoDatasetV2UpdateReq
    """ # noqa: E501
    data_source: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(default=None, description="Data source description")
    description: Optional[Annotated[str, Field(strict=True, max_length=1000)]] = Field(default=None, description="Dataset description")
    format: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Data format")
    injection_refs: Optional[List[DtoInjectionRef]] = Field(default=None, description="Update associated fault injection references (complete replacement)")
    is_public: Optional[StrictBool] = Field(default=None, description="Whether public")
    label_ids: Optional[List[StrictInt]] = Field(default=None, description="Update associated label ID list (complete replacement)")
    name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(default=None, description="Dataset name")
    new_labels: Optional[List[DtoDatasetV2LabelCreateReq]] = Field(default=None, description="New label list")
    type: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Dataset type")
    version: Optional[Annotated[str, Field(strict=True, max_length=50)]] = Field(default=None, description="Dataset version")
    __properties: ClassVar[List[str]] = ["data_source", "description", "format", "injection_refs", "is_public", "label_ids", "name", "new_labels", "type", "version"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoDatasetV2UpdateReq from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in injection_refs (list)
        _items = []
        if self.injection_refs:
            for _item in self.injection_refs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['injection_refs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in new_labels (list)
        _items = []
        if self.new_labels:
            for _item in self.new_labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['new_labels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoDatasetV2UpdateReq from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "data_source": obj.get("data_source"),
            "description": obj.get("description"),
            "format": obj.get("format"),
            "injection_refs": [DtoInjectionRef.from_dict(_item) for _item in obj.get("injection_refs")] if obj.get("injection_refs") is not None else None,
            "is_public": obj.get("is_public"),
            "label_ids": obj.get("label_ids"),
            "name": obj.get("name"),
            "new_labels": [DtoDatasetV2LabelCreateReq.from_dict(_item) for _item in obj.get("new_labels")] if obj.get("new_labels") is not None else None,
            "type": obj.get("type"),
            "version": obj.get("version")
        })
        return _obj


