# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr
from rcabench.openapi.models.handler_node import HandlerNode
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoFaultInjectionWithIssuesResp(BaseModel):
    """
    DtoFaultInjectionWithIssuesResp
    """ # noqa: E501
    abnormal_avg_duration: Optional[Union[StrictFloat, StrictInt]] = None
    abnormal_p99: Optional[Union[StrictFloat, StrictInt]] = None
    abnormal_succ_rate: Optional[Union[StrictFloat, StrictInt]] = None
    dataset_id: Optional[StrictInt] = None
    engine_config: Optional[HandlerNode] = None
    injection_name: Optional[StrictStr] = None
    issues: Optional[StrictStr] = None
    normal_avg_duration: Optional[Union[StrictFloat, StrictInt]] = None
    normal_p99: Optional[Union[StrictFloat, StrictInt]] = None
    normal_succ_rate: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["abnormal_avg_duration", "abnormal_p99", "abnormal_succ_rate", "dataset_id", "engine_config", "injection_name", "issues", "normal_avg_duration", "normal_p99", "normal_succ_rate"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoFaultInjectionWithIssuesResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of engine_config
        if self.engine_config:
            _dict['engine_config'] = self.engine_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoFaultInjectionWithIssuesResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "abnormal_avg_duration": obj.get("abnormal_avg_duration"),
            "abnormal_p99": obj.get("abnormal_p99"),
            "abnormal_succ_rate": obj.get("abnormal_succ_rate"),
            "dataset_id": obj.get("dataset_id"),
            "engine_config": HandlerNode.from_dict(obj.get("engine_config")) if obj.get("engine_config") is not None else None,
            "injection_name": obj.get("injection_name"),
            "issues": obj.get("issues"),
            "normal_avg_duration": obj.get("normal_avg_duration"),
            "normal_p99": obj.get("normal_p99"),
            "normal_succ_rate": obj.get("normal_succ_rate")
        })
        return _obj


