# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt
from rcabench.openapi.models.dto_attribute_coverage_item import DtoAttributeCoverageItem
from rcabench.openapi.models.dto_pair_stats import DtoPairStats
from rcabench.openapi.models.dto_service_coverage_item import DtoServiceCoverageItem
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoInjectionDiversity(BaseModel):
    """
    DtoInjectionDiversity
    """ # noqa: E501
    attribute_coverages: Optional[Dict[str, Dict[str, DtoAttributeCoverageItem]]] = None
    fault_distribution: Optional[Dict[str, StrictInt]] = None
    fault_service_coverages: Optional[Dict[str, DtoServiceCoverageItem]] = None
    pair_distribution: Optional[List[DtoPairStats]] = None
    service_distribution: Optional[Dict[str, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["attribute_coverages", "fault_distribution", "fault_service_coverages", "pair_distribution", "service_distribution"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoInjectionDiversity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in attribute_coverages (dict)
        _field_dict = {}
        if self.attribute_coverages:
            for _key in self.attribute_coverages:
                if self.attribute_coverages[_key]:
                    _field_dict[_key] = self.attribute_coverages[_key].to_dict()
            _dict['attribute_coverages'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in fault_service_coverages (dict)
        _field_dict = {}
        if self.fault_service_coverages:
            for _key in self.fault_service_coverages:
                if self.fault_service_coverages[_key]:
                    _field_dict[_key] = self.fault_service_coverages[_key].to_dict()
            _dict['fault_service_coverages'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in pair_distribution (list)
        _items = []
        if self.pair_distribution:
            for _item in self.pair_distribution:
                if _item:
                    _items.append(_item.to_dict())
            _dict['pair_distribution'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoInjectionDiversity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attribute_coverages": dict(
                (_k, dict(
                    (_ik, DtoAttributeCoverageItem.from_dict(_iv))
                        for _ik, _iv in _v.items()
                    )
                    if _v is not None
                    else None
                )
                for _k, _v in obj.get("attribute_coverages").items()
            )
            if obj.get("attribute_coverages") is not None
            else None,
            "fault_distribution": obj.get("fault_distribution"),
            "fault_service_coverages": dict(
                (_k, DtoServiceCoverageItem.from_dict(_v))
                for _k, _v in obj.get("fault_service_coverages").items()
            )
            if obj.get("fault_service_coverages") is not None
            else None,
            "pair_distribution": [DtoPairStats.from_dict(_item) for _item in obj.get("pair_distribution")] if obj.get("pair_distribution") is not None else None,
            "service_distribution": obj.get("service_distribution")
        })
        return _obj


