# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoInjectionItem(BaseModel):
    """
    DtoInjectionItem
    """ # noqa: E501
    batch: Optional[StrictStr] = None
    benchmark: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    display_config: Optional[StrictStr] = None
    end_time: Optional[StrictStr] = None
    engine_config: Optional[StrictStr] = None
    env: Optional[StrictStr] = None
    fault_type: Optional[StrictInt] = None
    id: Optional[StrictInt] = None
    injection_name: Optional[StrictStr] = None
    pre_duration: Optional[StrictInt] = None
    start_time: Optional[StrictStr] = None
    status: Optional[StrictInt] = None
    tag: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["batch", "benchmark", "created_at", "display_config", "end_time", "engine_config", "env", "fault_type", "id", "injection_name", "pre_duration", "start_time", "status", "tag"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoInjectionItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoInjectionItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "batch": obj.get("batch"),
            "benchmark": obj.get("benchmark"),
            "created_at": obj.get("created_at"),
            "display_config": obj.get("display_config"),
            "end_time": obj.get("end_time"),
            "engine_config": obj.get("engine_config"),
            "env": obj.get("env"),
            "fault_type": obj.get("fault_type"),
            "id": obj.get("id"),
            "injection_name": obj.get("injection_name"),
            "pre_duration": obj.get("pre_duration"),
            "start_time": obj.get("start_time"),
            "status": obj.get("status"),
            "tag": obj.get("tag")
        })
        return _obj


