# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from rcabench.openapi.models.dto_injection_create_error import DtoInjectionCreateError
from rcabench.openapi.models.dto_injection_v2_response import DtoInjectionV2Response
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoInjectionV2CreateResponse(BaseModel):
    """
    DtoInjectionV2CreateResponse
    """ # noqa: E501
    created_count: Optional[StrictInt] = None
    created_items: Optional[List[DtoInjectionV2Response]] = None
    failed_count: Optional[StrictInt] = None
    failed_items: Optional[List[DtoInjectionCreateError]] = None
    message: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["created_count", "created_items", "failed_count", "failed_items", "message"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoInjectionV2CreateResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in created_items (list)
        _items = []
        if self.created_items:
            for _item in self.created_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['created_items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in failed_items (list)
        _items = []
        if self.failed_items:
            for _item in self.failed_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['failed_items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoInjectionV2CreateResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_count": obj.get("created_count"),
            "created_items": [DtoInjectionV2Response.from_dict(_item) for _item in obj.get("created_items")] if obj.get("created_items") is not None else None,
            "failed_count": obj.get("failed_count"),
            "failed_items": [DtoInjectionCreateError.from_dict(_item) for _item in obj.get("failed_items")] if obj.get("failed_items") is not None else None,
            "message": obj.get("message")
        })
        return _obj


