# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
from pydantic import Field
from typing_extensions import Annotated
from rcabench.openapi.models.dto_label_item import DtoLabelItem
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoInjectionV2SearchReq(BaseModel):
    """
    DtoInjectionV2SearchReq
    """ # noqa: E501
    benchmarks: Optional[List[StrictStr]] = None
    created_at_gte: Optional[StrictStr] = None
    created_at_lte: Optional[StrictStr] = None
    end_time_gte: Optional[StrictStr] = None
    end_time_lte: Optional[StrictStr] = None
    fault_types: Optional[List[StrictInt]] = None
    include: Optional[StrictStr] = None
    labels: Optional[List[DtoLabelItem]] = Field(default=None, description="Custom labels to filter by")
    page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None
    search: Optional[StrictStr] = None
    size: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = None
    sort_by: Optional[StrictStr] = None
    sort_order: Optional[StrictStr] = None
    start_time_gte: Optional[StrictStr] = None
    start_time_lte: Optional[StrictStr] = None
    statuses: Optional[List[StrictInt]] = None
    tags: Optional[List[StrictStr]] = Field(default=None, description="Tag values to filter by")
    task_ids: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["benchmarks", "created_at_gte", "created_at_lte", "end_time_gte", "end_time_lte", "fault_types", "include", "labels", "page", "search", "size", "sort_by", "sort_order", "start_time_gte", "start_time_lte", "statuses", "tags", "task_ids"]

    @field_validator('sort_by')
    def sort_by_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('id', 'task_id', 'fault_type', 'status', 'benchmark', 'injection_name', 'created_at', 'updated_at'):
            raise ValueError("must be one of enum values ('id', 'task_id', 'fault_type', 'status', 'benchmark', 'injection_name', 'created_at', 'updated_at')")
        return value

    @field_validator('sort_order')
    def sort_order_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('asc', 'desc'):
            raise ValueError("must be one of enum values ('asc', 'desc')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoInjectionV2SearchReq from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item in self.labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['labels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoInjectionV2SearchReq from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "benchmarks": obj.get("benchmarks"),
            "created_at_gte": obj.get("created_at_gte"),
            "created_at_lte": obj.get("created_at_lte"),
            "end_time_gte": obj.get("end_time_gte"),
            "end_time_lte": obj.get("end_time_lte"),
            "fault_types": obj.get("fault_types"),
            "include": obj.get("include"),
            "labels": [DtoLabelItem.from_dict(_item) for _item in obj.get("labels")] if obj.get("labels") is not None else None,
            "page": obj.get("page"),
            "search": obj.get("search"),
            "size": obj.get("size"),
            "sort_by": obj.get("sort_by"),
            "sort_order": obj.get("sort_order"),
            "start_time_gte": obj.get("start_time_gte"),
            "start_time_lte": obj.get("start_time_lte"),
            "statuses": obj.get("statuses"),
            "tags": obj.get("tags"),
            "task_ids": obj.get("task_ids")
        })
        return _obj


