# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from typing_extensions import Annotated
from rcabench.openapi.models.dto_date_range import DtoDateRange
from rcabench.openapi.models.dto_search_filter import DtoSearchFilter
from rcabench.openapi.models.dto_sort_option import DtoSortOption
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoPermissionSearchRequest(BaseModel):
    """
    DtoPermissionSearchRequest
    """ # noqa: E501
    actions: Optional[List[StrictStr]] = Field(default=None, description="Action filter")
    created_at: Optional[DtoDateRange] = None
    description_pattern: Optional[StrictStr] = Field(default=None, description="Fuzzy match for description")
    display_name_pattern: Optional[StrictStr] = Field(default=None, description="Fuzzy match for display name")
    exclude_fields: Optional[List[StrictStr]] = None
    filters: Optional[List[DtoSearchFilter]] = Field(default=None, description="Filters")
    include: Optional[List[StrictStr]] = Field(default=None, description="Include related entities")
    include_fields: Optional[List[StrictStr]] = Field(default=None, description="Include/Exclude fields")
    is_active: Optional[StrictBool] = None
    is_system: Optional[StrictBool] = Field(default=None, description="Is system permission")
    keyword: Optional[StrictStr] = Field(default=None, description="Search keyword (for general text search)")
    name_pattern: Optional[StrictStr] = Field(default=None, description="Permission-specific filter shortcuts")
    page: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, description="Pagination")
    project_id: Optional[StrictInt] = None
    resource_ids: Optional[List[StrictInt]] = Field(default=None, description="Resource ID filter")
    resource_names: Optional[List[StrictStr]] = Field(default=None, description="Resource name filter")
    role_ids: Optional[List[StrictInt]] = Field(default=None, description="Role IDs that have this permission")
    size: Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]] = None
    sort: Optional[List[DtoSortOption]] = Field(default=None, description="Sort")
    status: Optional[List[StrictInt]] = None
    updated_at: Optional[DtoDateRange] = None
    user_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["actions", "created_at", "description_pattern", "display_name_pattern", "exclude_fields", "filters", "include", "include_fields", "is_active", "is_system", "keyword", "name_pattern", "page", "project_id", "resource_ids", "resource_names", "role_ids", "size", "sort", "status", "updated_at", "user_id"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoPermissionSearchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_at
        if self.created_at:
            _dict['created_at'] = self.created_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item in self.filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sort (list)
        _items = []
        if self.sort:
            for _item in self.sort:
                if _item:
                    _items.append(_item.to_dict())
            _dict['sort'] = _items
        # override the default output from pydantic by calling `to_dict()` of updated_at
        if self.updated_at:
            _dict['updated_at'] = self.updated_at.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoPermissionSearchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actions": obj.get("actions"),
            "created_at": DtoDateRange.from_dict(obj.get("created_at")) if obj.get("created_at") is not None else None,
            "description_pattern": obj.get("description_pattern"),
            "display_name_pattern": obj.get("display_name_pattern"),
            "exclude_fields": obj.get("exclude_fields"),
            "filters": [DtoSearchFilter.from_dict(_item) for _item in obj.get("filters")] if obj.get("filters") is not None else None,
            "include": obj.get("include"),
            "include_fields": obj.get("include_fields"),
            "is_active": obj.get("is_active"),
            "is_system": obj.get("is_system"),
            "keyword": obj.get("keyword"),
            "name_pattern": obj.get("name_pattern"),
            "page": obj.get("page"),
            "project_id": obj.get("project_id"),
            "resource_ids": obj.get("resource_ids"),
            "resource_names": obj.get("resource_names"),
            "role_ids": obj.get("role_ids"),
            "size": obj.get("size"),
            "sort": [DtoSortOption.from_dict(_item) for _item in obj.get("sort")] if obj.get("sort") is not None else None,
            "status": obj.get("status"),
            "updated_at": DtoDateRange.from_dict(obj.get("updated_at")) if obj.get("updated_at") is not None else None,
            "user_id": obj.get("user_id")
        })
        return _obj


