# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr
from pydantic import Field
from rcabench.openapi.models.database_task import DatabaseTask
from rcabench.openapi.models.handler_groundtruth import HandlerGroundtruth
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoQueryInjectionResp(BaseModel):
    """
    DtoQueryInjectionResp
    """ # noqa: E501
    benchmark: Optional[StrictStr] = Field(default=None, description="Benchmark database, add index and size limit")
    created_at: Optional[StrictStr] = Field(default=None, description="Creation time, add time index")
    description: Optional[StrictStr] = Field(default=None, description="Description (optional field)")
    display_config: Optional[StrictStr] = Field(default=None, description="User-facing display configuration")
    end_time: Optional[StrictStr] = Field(default=None, description="Expected fault end time, nullable")
    engine_config: Optional[StrictStr] = Field(default=None, description="System-facing runtime configuration")
    fault_type: Optional[StrictInt] = Field(default=None, description="Fault type, add composite index")
    ground_truth: Optional[HandlerGroundtruth] = None
    id: Optional[StrictInt] = Field(default=None, description="Unique identifier")
    injection_name: Optional[StrictStr] = Field(default=None, description="Name injected in k8s resources with size limit")
    pre_duration: Optional[StrictInt] = Field(default=None, description="Normal data duration")
    start_time: Optional[StrictStr] = Field(default=None, description="Expected fault start time, nullable with validation")
    status: Optional[StrictInt] = Field(default=None, description="Status: -1:deleted 0:disabled 1:enabled")
    task: Optional[DatabaseTask] = None
    task_id: Optional[StrictStr] = Field(default=None, description="Associated task ID, add composite index")
    updated_at: Optional[StrictStr] = Field(default=None, description="Update time")
    __properties: ClassVar[List[str]] = ["benchmark", "created_at", "description", "display_config", "end_time", "engine_config", "fault_type", "ground_truth", "id", "injection_name", "pre_duration", "start_time", "status", "task", "task_id", "updated_at"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoQueryInjectionResp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of ground_truth
        if self.ground_truth:
            _dict['ground_truth'] = self.ground_truth.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task
        if self.task:
            _dict['task'] = self.task.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoQueryInjectionResp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "benchmark": obj.get("benchmark"),
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "display_config": obj.get("display_config"),
            "end_time": obj.get("end_time"),
            "engine_config": obj.get("engine_config"),
            "fault_type": obj.get("fault_type"),
            "ground_truth": HandlerGroundtruth.from_dict(obj.get("ground_truth")) if obj.get("ground_truth") is not None else None,
            "id": obj.get("id"),
            "injection_name": obj.get("injection_name"),
            "pre_duration": obj.get("pre_duration"),
            "start_time": obj.get("start_time"),
            "status": obj.get("status"),
            "task": DatabaseTask.from_dict(obj.get("task")) if obj.get("task") is not None else None,
            "task_id": obj.get("task_id"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


