# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoRoleResponse(BaseModel):
    """
    DtoRoleResponse
    """ # noqa: E501
    created_at: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    display_name: Optional[StrictStr] = None
    id: Optional[StrictInt] = None
    is_system: Optional[StrictBool] = None
    name: Optional[StrictStr] = None
    permissions: Optional[List[DtoPermissionResponse]] = None
    status: Optional[StrictInt] = None
    type: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    user_count: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["created_at", "description", "display_name", "id", "is_system", "name", "permissions", "status", "type", "updated_at", "user_count"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoRoleResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoRoleResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "description": obj.get("description"),
            "display_name": obj.get("display_name"),
            "id": obj.get("id"),
            "is_system": obj.get("is_system"),
            "name": obj.get("name"),
            "permissions": [DtoPermissionResponse.from_dict(_item) for _item in obj.get("permissions")] if obj.get("permissions") is not None else None,
            "status": obj.get("status"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at"),
            "user_count": obj.get("user_count")
        })
        return _obj

from rcabench.openapi.models.dto_permission_response import DtoPermissionResponse
# TODO: Rewrite to not use raise_errors
DtoRoleResponse.model_rebuild(raise_errors=False)

