# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel
from rcabench.openapi.models.dto_dataset_v2_response import DtoDatasetV2Response
from rcabench.openapi.models.dto_pagination_info import DtoPaginationInfo
from rcabench.openapi.models.dto_search_filter import DtoSearchFilter
from rcabench.openapi.models.dto_sort_option import DtoSortOption
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoSearchResponseDtoDatasetV2Response(BaseModel):
    """
    DtoSearchResponseDtoDatasetV2Response
    """ # noqa: E501
    applied_filters: Optional[List[DtoSearchFilter]] = None
    applied_sort: Optional[List[DtoSortOption]] = None
    items: Optional[List[DtoDatasetV2Response]] = None
    pagination: Optional[DtoPaginationInfo] = None
    __properties: ClassVar[List[str]] = ["applied_filters", "applied_sort", "items", "pagination"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoSearchResponseDtoDatasetV2Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in applied_filters (list)
        _items = []
        if self.applied_filters:
            for _item in self.applied_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['applied_filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in applied_sort (list)
        _items = []
        if self.applied_sort:
            for _item in self.applied_sort:
                if _item:
                    _items.append(_item.to_dict())
            _dict['applied_sort'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoSearchResponseDtoDatasetV2Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applied_filters": [DtoSearchFilter.from_dict(_item) for _item in obj.get("applied_filters")] if obj.get("applied_filters") is not None else None,
            "applied_sort": [DtoSortOption.from_dict(_item) for _item in obj.get("applied_sort")] if obj.get("applied_sort") is not None else None,
            "items": [DtoDatasetV2Response.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None,
            "pagination": DtoPaginationInfo.from_dict(obj.get("pagination")) if obj.get("pagination") is not None else None
        })
        return _obj


