# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from typing_extensions import Annotated
from rcabench.openapi.models.dto_algorithm_item import DtoAlgorithmItem
from rcabench.openapi.models.dto_label_item import DtoLabelItem
from rcabench.openapi.models.handler_node import HandlerNode
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoSubmitInjectionReq(BaseModel):
    """
    DtoSubmitInjectionReq
    """ # noqa: E501
    algorithms: Optional[List[DtoAlgorithmItem]] = None
    benchmark: StrictStr
    interval: Annotated[int, Field(strict=True, ge=1)]
    labels: Optional[List[DtoLabelItem]] = None
    pre_duration: Annotated[int, Field(strict=True, ge=1)]
    project_name: StrictStr
    specs: List[HandlerNode]
    __properties: ClassVar[List[str]] = ["algorithms", "benchmark", "interval", "labels", "pre_duration", "project_name", "specs"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoSubmitInjectionReq from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in algorithms (list)
        _items = []
        if self.algorithms:
            for _item in self.algorithms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['algorithms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item in self.labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['labels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in specs (list)
        _items = []
        if self.specs:
            for _item in self.specs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['specs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoSubmitInjectionReq from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "algorithms": [DtoAlgorithmItem.from_dict(_item) for _item in obj.get("algorithms")] if obj.get("algorithms") is not None else None,
            "benchmark": obj.get("benchmark"),
            "interval": obj.get("interval"),
            "labels": [DtoLabelItem.from_dict(_item) for _item in obj.get("labels")] if obj.get("labels") is not None else None,
            "pre_duration": obj.get("pre_duration"),
            "project_name": obj.get("project_name"),
            "specs": [HandlerNode.from_dict(_item) for _item in obj.get("specs")] if obj.get("specs") is not None else None
        })
        return _obj


