# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from rcabench.openapi.models.dto_container_statistics import DtoContainerStatistics
from rcabench.openapi.models.dto_dataset_statistics import DtoDatasetStatistics
from rcabench.openapi.models.dto_execution_statistics import DtoExecutionStatistics
from rcabench.openapi.models.dto_injection_statistics import DtoInjectionStatistics
from rcabench.openapi.models.dto_project_statistics import DtoProjectStatistics
from rcabench.openapi.models.dto_task_statistics import DtoTaskStatistics
from rcabench.openapi.models.dto_user_statistics import DtoUserStatistics
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoSystemStatisticsResponse(BaseModel):
    """
    DtoSystemStatisticsResponse
    """ # noqa: E501
    containers: Optional[DtoContainerStatistics] = None
    datasets: Optional[DtoDatasetStatistics] = None
    executions: Optional[DtoExecutionStatistics] = None
    generated_at: Optional[StrictStr] = None
    injections: Optional[DtoInjectionStatistics] = None
    projects: Optional[DtoProjectStatistics] = None
    tasks: Optional[DtoTaskStatistics] = None
    users: Optional[DtoUserStatistics] = None
    __properties: ClassVar[List[str]] = ["containers", "datasets", "executions", "generated_at", "injections", "projects", "tasks", "users"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoSystemStatisticsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of containers
        if self.containers:
            _dict['containers'] = self.containers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of datasets
        if self.datasets:
            _dict['datasets'] = self.datasets.to_dict()
        # override the default output from pydantic by calling `to_dict()` of executions
        if self.executions:
            _dict['executions'] = self.executions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of injections
        if self.injections:
            _dict['injections'] = self.injections.to_dict()
        # override the default output from pydantic by calling `to_dict()` of projects
        if self.projects:
            _dict['projects'] = self.projects.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tasks
        if self.tasks:
            _dict['tasks'] = self.tasks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of users
        if self.users:
            _dict['users'] = self.users.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoSystemStatisticsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "containers": DtoContainerStatistics.from_dict(obj.get("containers")) if obj.get("containers") is not None else None,
            "datasets": DtoDatasetStatistics.from_dict(obj.get("datasets")) if obj.get("datasets") is not None else None,
            "executions": DtoExecutionStatistics.from_dict(obj.get("executions")) if obj.get("executions") is not None else None,
            "generated_at": obj.get("generated_at"),
            "injections": DtoInjectionStatistics.from_dict(obj.get("injections")) if obj.get("injections") is not None else None,
            "projects": DtoProjectStatistics.from_dict(obj.get("projects")) if obj.get("projects") is not None else None,
            "tasks": DtoTaskStatistics.from_dict(obj.get("tasks")) if obj.get("tasks") is not None else None,
            "users": DtoUserStatistics.from_dict(obj.get("users")) if obj.get("users") is not None else None
        })
        return _obj


