# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from rcabench.openapi.models.dto_project_response import DtoProjectResponse
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoTaskDetailResponse(BaseModel):
    """
    DtoTaskDetailResponse
    """ # noqa: E501
    created_at: Optional[StrictStr] = None
    group_id: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    immediate: Optional[StrictBool] = None
    logs: Optional[List[StrictStr]] = None
    project: Optional[DtoProjectResponse] = None
    project_id: Optional[StrictInt] = None
    status: Optional[StrictStr] = None
    trace_id: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["created_at", "group_id", "id", "immediate", "logs", "project", "project_id", "status", "trace_id", "type", "updated_at"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoTaskDetailResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoTaskDetailResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "group_id": obj.get("group_id"),
            "id": obj.get("id"),
            "immediate": obj.get("immediate"),
            "logs": obj.get("logs"),
            "project": DtoProjectResponse.from_dict(obj.get("project")) if obj.get("project") is not None else None,
            "project_id": obj.get("project_id"),
            "status": obj.get("status"),
            "trace_id": obj.get("trace_id"),
            "type": obj.get("type"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


