# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, StrictStr
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoTraceStats(BaseModel):
    """
    DtoTraceStats
    """ # noqa: E501
    avg_duration: Optional[Union[StrictFloat, StrictInt]] = None
    end_count_map: Optional[Dict[str, Dict[str, StrictInt]]] = None
    fault_injection_traces: Optional[List[StrictStr]] = None
    max_duration: Optional[Union[StrictFloat, StrictInt]] = None
    min_duration: Optional[Union[StrictFloat, StrictInt]] = None
    total: Optional[StrictInt] = None
    trace_completed_list: Optional[List[StrictStr]] = None
    trace_errors: Optional[Dict[str, Any]] = None
    trace_status_time_map: Optional[Dict[str, Dict[str, Union[StrictFloat, StrictInt]]]] = None
    __properties: ClassVar[List[str]] = ["avg_duration", "end_count_map", "fault_injection_traces", "max_duration", "min_duration", "total", "trace_completed_list", "trace_errors", "trace_status_time_map"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoTraceStats from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoTraceStats from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avg_duration": obj.get("avg_duration"),
            "end_count_map": obj.get("end_count_map"),
            "fault_injection_traces": obj.get("fault_injection_traces"),
            "max_duration": obj.get("max_duration"),
            "min_duration": obj.get("min_duration"),
            "total": obj.get("total"),
            "trace_completed_list": obj.get("trace_completed_list"),
            "trace_errors": obj.get("trace_errors"),
            "trace_status_time_map": obj.get("trace_status_time_map")
        })
        return _obj


