# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from pydantic import Field
from rcabench.openapi.models.consts_task_type import ConstsTaskType
from rcabench.openapi.models.dto_retry_policy import DtoRetryPolicy
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoUnifiedTask(BaseModel):
    """
    DtoUnifiedTask
    """ # noqa: E501
    cron_expr: Optional[StrictStr] = Field(default=None, description="Cron expression for recurring tasks")
    execute_time: Optional[StrictInt] = Field(default=None, description="Unix timestamp for delayed execution")
    group_carrier: Optional[Dict[str, StrictStr]] = None
    group_id: Optional[StrictStr] = Field(default=None, description="ID for grouping tasks")
    immediate: Optional[StrictBool] = Field(default=None, description="Whether to execute immediately")
    payload: Optional[Dict[str, Any]] = Field(default=None, description="Task-specific data")
    project_id: Optional[StrictInt] = Field(default=None, description="ID for the project (optional)")
    restart_num: Optional[StrictInt] = Field(default=None, description="Number of restarts for the task")
    retry_policy: Optional[DtoRetryPolicy] = None
    status: Optional[StrictStr] = Field(default=None, description="Status of the task")
    task_id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the task")
    trace_carrier: Optional[Dict[str, StrictStr]] = None
    trace_id: Optional[StrictStr] = Field(default=None, description="ID for tracing related tasks")
    type: Optional[ConstsTaskType] = None
    __properties: ClassVar[List[str]] = ["cron_expr", "execute_time", "group_carrier", "group_id", "immediate", "payload", "project_id", "restart_num", "retry_policy", "status", "task_id", "trace_carrier", "trace_id", "type"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoUnifiedTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of retry_policy
        if self.retry_policy:
            _dict['retry_policy'] = self.retry_policy.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoUnifiedTask from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cron_expr": obj.get("cron_expr"),
            "execute_time": obj.get("execute_time"),
            "group_carrier": obj.get("group_carrier"),
            "group_id": obj.get("group_id"),
            "immediate": obj.get("immediate"),
            "payload": obj.get("payload"),
            "project_id": obj.get("project_id"),
            "restart_num": obj.get("restart_num"),
            "retry_policy": DtoRetryPolicy.from_dict(obj.get("retry_policy")) if obj.get("retry_policy") is not None else None,
            "status": obj.get("status"),
            "task_id": obj.get("task_id"),
            "trace_carrier": obj.get("trace_carrier"),
            "trace_id": obj.get("trace_id"),
            "type": obj.get("type")
        })
        return _obj


