# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictBool, StrictInt, StrictStr
from rcabench.openapi.models.dto_permission_response import DtoPermissionResponse
from rcabench.openapi.models.dto_role_response import DtoRoleResponse
from rcabench.openapi.models.dto_user_project_response import DtoUserProjectResponse
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class DtoUserResponse(BaseModel):
    """
    DtoUserResponse
    """ # noqa: E501
    avatar: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    full_name: Optional[StrictStr] = None
    global_roles: Optional[List[DtoRoleResponse]] = None
    id: Optional[StrictInt] = None
    is_active: Optional[StrictBool] = None
    last_login_at: Optional[StrictStr] = None
    permissions: Optional[List[DtoPermissionResponse]] = None
    phone: Optional[StrictStr] = None
    project_roles: Optional[List[DtoUserProjectResponse]] = None
    status: Optional[StrictInt] = None
    updated_at: Optional[StrictStr] = None
    username: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["avatar", "created_at", "email", "full_name", "global_roles", "id", "is_active", "last_login_at", "permissions", "phone", "project_roles", "status", "updated_at", "username"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of DtoUserResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in global_roles (list)
        _items = []
        if self.global_roles:
            for _item in self.global_roles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['global_roles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in permissions (list)
        _items = []
        if self.permissions:
            for _item in self.permissions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['permissions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in project_roles (list)
        _items = []
        if self.project_roles:
            for _item in self.project_roles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['project_roles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of DtoUserResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "avatar": obj.get("avatar"),
            "created_at": obj.get("created_at"),
            "email": obj.get("email"),
            "full_name": obj.get("full_name"),
            "global_roles": [DtoRoleResponse.from_dict(_item) for _item in obj.get("global_roles")] if obj.get("global_roles") is not None else None,
            "id": obj.get("id"),
            "is_active": obj.get("is_active"),
            "last_login_at": obj.get("last_login_at"),
            "permissions": [DtoPermissionResponse.from_dict(_item) for _item in obj.get("permissions")] if obj.get("permissions") is not None else None,
            "phone": obj.get("phone"),
            "project_roles": [DtoUserProjectResponse.from_dict(_item) for _item in obj.get("project_roles")] if obj.get("project_roles") is not None else None,
            "status": obj.get("status"),
            "updated_at": obj.get("updated_at"),
            "username": obj.get("username")
        })
        return _obj


