# coding: utf-8

"""
    RCABench API

    RCABench - A comprehensive root cause analysis benchmarking platform for microservices This API provides endpoints for managing datasets, algorithms, evaluations, and fault injections for root cause analysis in distributed systems and microservices architectures.

    The version of the OpenAPI document: 1.0.1
    Contact: team@rcabench.com
    Generated by OpenAPI Generator (https://rcabench.openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from rcabench.openapi.models.handler_pair import HandlerPair
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class HandlerResources(BaseModel):
    """
    HandlerResources
    """ # noqa: E501
    app_labels: Optional[List[StrictStr]] = None
    container_names: Optional[List[StrictStr]] = None
    database_app_names: Optional[List[StrictStr]] = None
    dns_app_names: Optional[List[StrictStr]] = None
    http_app_names: Optional[List[StrictStr]] = None
    jvm_app_names: Optional[List[StrictStr]] = None
    network_pairs: Optional[List[HandlerPair]] = None
    __properties: ClassVar[List[str]] = ["app_labels", "container_names", "database_app_names", "dns_app_names", "http_app_names", "jvm_app_names", "network_pairs"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of HandlerResources from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in network_pairs (list)
        _items = []
        if self.network_pairs:
            for _item in self.network_pairs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['network_pairs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of HandlerResources from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "app_labels": obj.get("app_labels"),
            "container_names": obj.get("container_names"),
            "database_app_names": obj.get("database_app_names"),
            "dns_app_names": obj.get("dns_app_names"),
            "http_app_names": obj.get("http_app_names"),
            "jvm_app_names": obj.get("jvm_app_names"),
            "network_pairs": [HandlerPair.from_dict(_item) for _item in obj.get("network_pairs")] if obj.get("network_pairs") is not None else None
        })
        return _obj


