# Generated by Django 4.2.6 on 2023-11-01 00:43

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import oauth2_provider.generators
import oauth2_provider.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("mad_oauth2", "0005_auto_20211209_1009"),
    ]

    operations = [
        migrations.AddField(
            model_name="application",
            name="post_logout_redirect_uris",
            field=models.TextField(
                blank=True, help_text="Allowed Post Logout URIs list, space separated"
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="client_secret",
            field=oauth2_provider.models.ClientSecretField(
                blank=True,
                db_index=True,
                default=oauth2_provider.generators.generate_client_secret,
                help_text="Hashed on Save. Copy it now if this is a new secret.",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="scopes",
            field=models.ManyToManyField(
                related_name="%(app_label)s_%(class)s_scopes", to="mad_oauth2.scope"
            ),
        ),
        migrations.AlterField(
            model_name="application",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="%(app_label)s_%(class)s",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
    ]
