from pkgutil import extend_path
__path__ = extend_path(__path__, __name__)

import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

import typeguard
from importlib.metadata import version as _metadata_package_version
TYPEGUARD_MAJOR_VERSION = int(_metadata_package_version('typeguard').split('.')[0])

def check_type(argname: str, value: object, expected_type: typing.Any) -> typing.Any:
    if TYPEGUARD_MAJOR_VERSION <= 2:
        return typeguard.check_type(argname=argname, value=value, expected_type=expected_type) # type:ignore
    else:
        if isinstance(value, jsii._reference_map.InterfaceDynamicProxy): # pyright: ignore [reportAttributeAccessIssue]
           pass
        else:
            if TYPEGUARD_MAJOR_VERSION == 3:
                typeguard.config.collection_check_strategy = typeguard.CollectionCheckStrategy.ALL_ITEMS # type:ignore
                typeguard.check_type(value=value, expected_type=expected_type) # type:ignore
            else:
                typeguard.check_type(value=value, expected_type=expected_type, collection_check_strategy=typeguard.CollectionCheckStrategy.ALL_ITEMS) # type:ignore

from ....._jsii import *


@jsii.enum(jsii_type="@aws/pdk.aws_arch.aws_arch.DrawioSpec.Aws4.ShapeNames")
class ShapeNames(enum.Enum):
    A1_INSTANCE = "A1_INSTANCE"
    ACCESS_ANALYZER = "ACCESS_ANALYZER"
    ACTION = "ACTION"
    ACTIVATE = "ACTIVATE"
    ACTUATOR = "ACTUATOR"
    ADDON = "ADDON"
    AD_CONNECTOR = "AD_CONNECTOR"
    AGENT = "AGENT"
    AGENT2 = "AGENT2"
    ALARM = "ALARM"
    ALEXA_ENABLED_DEVICE = "ALEXA_ENABLED_DEVICE"
    ALEXA_FOR_BUSINESS = "ALEXA_FOR_BUSINESS"
    ALEXA_SKILL = "ALEXA_SKILL"
    ALEXA_SMART_HOME_SKILL = "ALEXA_SMART_HOME_SKILL"
    ALEXA_VOICE_SERVICE = "ALEXA_VOICE_SERVICE"
    ALL_PRODUCTS = "ALL_PRODUCTS"
    AMI = "AMI"
    AMPLIFY = "AMPLIFY"
    AMPLIFY_AWS_AMPLIFY_STUDIO = "AMPLIFY_AWS_AMPLIFY_STUDIO"
    ANALYTICS = "ANALYTICS"
    APACHE_MXNET_ON_AWS = "APACHE_MXNET_ON_AWS"
    API_GATEWAY = "API_GATEWAY"
    APPFLOW = "APPFLOW"
    APPLICATION = "APPLICATION"
    APPLICATION_AUTO_SCALING = "APPLICATION_AUTO_SCALING"
    APPLICATION_COST_PROFILER = "APPLICATION_COST_PROFILER"
    APPLICATION_DISCOVERY_SERVICE = "APPLICATION_DISCOVERY_SERVICE"
    APPLICATION_INTEGRATION = "APPLICATION_INTEGRATION"
    APPLICATION_LOAD_BALANCER = "APPLICATION_LOAD_BALANCER"
    APPS = "APPS"
    APPSTREAM_20 = "APPSTREAM_20"
    APPSYNC = "APPSYNC"
    APP_CONFIG = "APP_CONFIG"
    APP_MESH = "APP_MESH"
    APP_RUNNER = "APP_RUNNER"
    APP_WIZARD = "APP_WIZARD"
    ARCHIVE = "ARCHIVE"
    ARTIFACT = "ARTIFACT"
    AR_VR = "AR_VR"
    ATHENA = "ATHENA"
    ATTRIBUTE = "ATTRIBUTE"
    ATTRIBUTES = "ATTRIBUTES"
    AUDIT_MANAGER = "AUDIT_MANAGER"
    AUGMENTED_AI = "AUGMENTED_AI"
    AURORA = "AURORA"
    AURORA_INSTANCE = "AURORA_INSTANCE"
    AURORA_INSTANCE_ALT = "AURORA_INSTANCE_ALT"
    AUTOMATION = "AUTOMATION"
    AUTOSCALING = "AUTOSCALING"
    AUTO_SCALING = "AUTO_SCALING"
    AUTO_SCALING2 = "AUTO_SCALING2"
    AUTO_SCALING3 = "AUTO_SCALING3"
    AWS_CLOUD = "AWS_CLOUD"
    BACKINT_AGENT = "BACKINT_AGENT"
    BACKUP = "BACKUP"
    BACKUP_AWS_BACKUP_SUPPORT_FOR_AMAZON_S3 = "BACKUP_AWS_BACKUP_SUPPORT_FOR_AMAZON_S3"
    BACKUP_AWS_BACKUP_SUPPORT_FOR_VMWARE_WORKLOADS = "BACKUP_AWS_BACKUP_SUPPORT_FOR_VMWARE_WORKLOADS"
    BACKUP_BACKUP_PLAN = "BACKUP_BACKUP_PLAN"
    BACKUP_BACKUP_RESTORE = "BACKUP_BACKUP_RESTORE"
    BACKUP_COMPLIANCE_REPORTING = "BACKUP_COMPLIANCE_REPORTING"
    BACKUP_COMPUTE = "BACKUP_COMPUTE"
    BACKUP_DATABASE = "BACKUP_DATABASE"
    BACKUP_GATEWAY = "BACKUP_GATEWAY"
    BACKUP_PLAN = "BACKUP_PLAN"
    BACKUP_RECOVERY_POINT_OBJECTIVE = "BACKUP_RECOVERY_POINT_OBJECTIVE"
    BACKUP_RECOVERY_TIME_OBJECTIVE = "BACKUP_RECOVERY_TIME_OBJECTIVE"
    BACKUP_RESTORE = "BACKUP_RESTORE"
    BACKUP_STORAGE = "BACKUP_STORAGE"
    BACKUP_VAULT = "BACKUP_VAULT"
    BACKUP_VIRTUAL_MACHINE = "BACKUP_VIRTUAL_MACHINE"
    BACKUP_VIRTUAL_MACHINE_MONITOR = "BACKUP_VIRTUAL_MACHINE_MONITOR"
    BANK = "BANK"
    BATCH = "BATCH"
    BLOCKCHAIN = "BLOCKCHAIN"
    BLOCKCHAIN_RESOURCE = "BLOCKCHAIN_RESOURCE"
    BOTTLEROCKET = "BOTTLEROCKET"
    BRAKET = "BRAKET"
    BRAKET_CHANDELIER = "BRAKET_CHANDELIER"
    BRAKET_CHIP = "BRAKET_CHIP"
    BRAKET_NOISE_SIMULATOR = "BRAKET_NOISE_SIMULATOR"
    BRAKET_QPU = "BRAKET_QPU"
    BRAKET_SIMULATOR = "BRAKET_SIMULATOR"
    BRAKET_SIMULATOR_1 = "BRAKET_SIMULATOR_1"
    BRAKET_SIMULATOR_2 = "BRAKET_SIMULATOR_2"
    BRAKET_SIMULATOR_3 = "BRAKET_SIMULATOR_3"
    BRAKET_SIMULATOR_4 = "BRAKET_SIMULATOR_4"
    BRAKET_STATE_VECTOR = "BRAKET_STATE_VECTOR"
    BRAKET_TENSOR_NETWORK = "BRAKET_TENSOR_NETWORK"
    BUCKET = "BUCKET"
    BUCKET_WITH_OBJECTS = "BUCKET_WITH_OBJECTS"
    BUDGETS = "BUDGETS"
    BUDGETS_2 = "BUDGETS_2"
    BUSINESS_APPLICATION = "BUSINESS_APPLICATION"
    BYCICLE = "BYCICLE"
    C4_INSTANCE = "C4_INSTANCE"
    C5A = "C5A"
    C5AD = "C5AD"
    C5D = "C5D"
    C5N_INSTANCE = "C5N_INSTANCE"
    C5_INSTANCE = "C5_INSTANCE"
    C6GD = "C6GD"
    C6G_INSTANCE = "C6G_INSTANCE"
    CACHED_VOLUME = "CACHED_VOLUME"
    CACHE_NODE = "CACHE_NODE"
    CAMERA = "CAMERA"
    CAMERA2 = "CAMERA2"
    CAR = "CAR"
    CART = "CART"
    CERTIFICATE_MANAGER = "CERTIFICATE_MANAGER"
    CERTIFICATE_MANAGER_2 = "CERTIFICATE_MANAGER_2"
    CERTIFICATE_MANAGER_3 = "CERTIFICATE_MANAGER_3"
    CHANGE_SET = "CHANGE_SET"
    CHATBOT = "CHATBOT"
    CHECKLIST = "CHECKLIST"
    CHECKLIST_COST = "CHECKLIST_COST"
    CHECKLIST_FAULT_TOLERANT = "CHECKLIST_FAULT_TOLERANT"
    CHECKLIST_PERFORMANCE = "CHECKLIST_PERFORMANCE"
    CHECKLIST_SECURITY = "CHECKLIST_SECURITY"
    CHIME = "CHIME"
    CHIME_SDK = "CHIME_SDK"
    CLASSIC_LOAD_BALANCER = "CLASSIC_LOAD_BALANCER"
    CLIENT = "CLIENT"
    CLIENT_VPN = "CLIENT_VPN"
    CLOUD9 = "CLOUD9"
    CLOUDENDURE_DISASTER_RECOVERY = "CLOUDENDURE_DISASTER_RECOVERY"
    CLOUDENDURE_MIGRATION = "CLOUDENDURE_MIGRATION"
    CLOUDFORMATION = "CLOUDFORMATION"
    CLOUDFRONT = "CLOUDFRONT"
    CLOUDFRONT_FUNCTIONS = "CLOUDFRONT_FUNCTIONS"
    CLOUDHSM = "CLOUDHSM"
    CLOUDSEARCH = "CLOUDSEARCH"
    CLOUDSEARCH2 = "CLOUDSEARCH2"
    CLOUDSHELL = "CLOUDSHELL"
    CLOUDTRAIL = "CLOUDTRAIL"
    CLOUDWATCH = "CLOUDWATCH"
    CLOUDWATCH_2 = "CLOUDWATCH_2"
    CLOUDWATCH_EVIDENTLY = "CLOUDWATCH_EVIDENTLY"
    CLOUDWATCH_METRICS_INSIGHTS = "CLOUDWATCH_METRICS_INSIGHTS"
    CLOUDWATCH_RUM = "CLOUDWATCH_RUM"
    CLOUDWATCH_SYNTHETICS = "CLOUDWATCH_SYNTHETICS"
    CLOUD_CONTROL_API = "CLOUD_CONTROL_API"
    CLOUD_DEVELOPMENT_KIT = "CLOUD_DEVELOPMENT_KIT"
    CLOUD_DIGITAL_INTERFACE = "CLOUD_DIGITAL_INTERFACE"
    CLOUD_DIRECTORY = "CLOUD_DIRECTORY"
    CLOUD_EXTENSION_ROS = "CLOUD_EXTENSION_ROS"
    CLOUD_MAP = "CLOUD_MAP"
    CLOUD_MAP_RESOURCE = "CLOUD_MAP_RESOURCE"
    CLOUD_WAN = "CLOUD_WAN"
    CLOUD_WAN_SEGMENT_NETWORK = "CLOUD_WAN_SEGMENT_NETWORK"
    CLOUD_WAN_VIRTUAL_POP = "CLOUD_WAN_VIRTUAL_POP"
    CLUSTER = "CLUSTER"
    CODEARTIFACT = "CODEARTIFACT"
    CODEBUILD = "CODEBUILD"
    CODECOMMIT = "CODECOMMIT"
    CODEDEPLOY = "CODEDEPLOY"
    CODEGURU = "CODEGURU"
    CODEGURU_2 = "CODEGURU_2"
    CODEPIPELINE = "CODEPIPELINE"
    CODESTAR = "CODESTAR"
    COFFEE_POT = "COFFEE_POT"
    COGNITO = "COGNITO"
    COMMAND_LINE_INTERFACE = "COMMAND_LINE_INTERFACE"
    COMPREHEND = "COMPREHEND"
    COMPREHEND_MEDICAL = "COMPREHEND_MEDICAL"
    COMPUTE = "COMPUTE"
    COMPUTE_OPTIMIZER = "COMPUTE_OPTIMIZER"
    CONFIG = "CONFIG"
    CONNECT = "CONNECT"
    CONNECTOR = "CONNECTOR"
    CONTAINERS = "CONTAINERS"
    CONTAINER_1 = "CONTAINER_1"
    CONTAINER_2 = "CONTAINER_2"
    CONTAINER_3 = "CONTAINER_3"
    CONTAINER_REGISTRY_IMAGE = "CONTAINER_REGISTRY_IMAGE"
    CONTROL_TOWER = "CONTROL_TOWER"
    CORPORATE_DATA_CENTER = "CORPORATE_DATA_CENTER"
    CORPORATE_DATA_CENTER2 = "CORPORATE_DATA_CENTER2"
    CORRETTO = "CORRETTO"
    COST_AND_USAGE_REPORT = "COST_AND_USAGE_REPORT"
    COST_EXPLORER = "COST_EXPLORER"
    COST_MANAGEMENT = "COST_MANAGEMENT"
    CUSTOMER_ENABLEMENT = "CUSTOMER_ENABLEMENT"
    CUSTOMER_ENGAGEMENT = "CUSTOMER_ENGAGEMENT"
    CUSTOMER_GATEWAY = "CUSTOMER_GATEWAY"
    CUSTOM_BILLING_MANAGER = "CUSTOM_BILLING_MANAGER"
    CUSTOM_EVENT_BUS_RESOURCE = "CUSTOM_EVENT_BUS_RESOURCE"
    D2_INSTANCE = "D2_INSTANCE"
    D3EN_INSTANCE = "D3EN_INSTANCE"
    D3_INSTANCE = "D3_INSTANCE"
    DATABASE = "DATABASE"
    DATABASE_MIGRATION_SERVICE = "DATABASE_MIGRATION_SERVICE"
    DATABASE_MIGRATION_WORKFLOW_JOB = "DATABASE_MIGRATION_WORKFLOW_JOB"
    DATASYNC = "DATASYNC"
    DATA_ENCRYPTION_KEY = "DATA_ENCRYPTION_KEY"
    DATA_EXCHANGE = "DATA_EXCHANGE"
    DATA_EXCHANGE_FOR_APIS = "DATA_EXCHANGE_FOR_APIS"
    DATA_LAKE_RESOURCE_ICON = "DATA_LAKE_RESOURCE_ICON"
    DATA_PIPELINE = "DATA_PIPELINE"
    DATA_SET = "DATA_SET"
    DB_INSTANCE = "DB_INSTANCE"
    DB_INSTANCE_READ_REPLICA = "DB_INSTANCE_READ_REPLICA"
    DB_INSTANCE_STANDBY = "DB_INSTANCE_STANDBY"
    DB_ON_INSTANCE = "DB_ON_INSTANCE"
    DB_ON_INSTANCE2 = "DB_ON_INSTANCE2"
    DEEPCOMPOSER = "DEEPCOMPOSER"
    DEEPLENS = "DEEPLENS"
    DEEPRACER = "DEEPRACER"
    DEEP_LEARNING_AMIS = "DEEP_LEARNING_AMIS"
    DEEP_LEARNING_CONTAINERS = "DEEP_LEARNING_CONTAINERS"
    DEFAULT_EVENT_BUS_RESOURCE = "DEFAULT_EVENT_BUS_RESOURCE"
    DENSE_COMPUTE_NODE = "DENSE_COMPUTE_NODE"
    DENSE_STORAGE_NODE = "DENSE_STORAGE_NODE"
    DEPLOYMENT = "DEPLOYMENT"
    DEPLOYMENTS = "DEPLOYMENTS"
    DESIRED_STATE = "DESIRED_STATE"
    DESKTOP_AND_APP_STREAMING = "DESKTOP_AND_APP_STREAMING"
    DETECTIVE = "DETECTIVE"
    DEVELOPER_TOOLS = "DEVELOPER_TOOLS"
    DEVELOPMENT_ENVIRONMENT = "DEVELOPMENT_ENVIRONMENT"
    DEVICE_FARM = "DEVICE_FARM"
    DEVOPS_GURU = "DEVOPS_GURU"
    DEVOPS_GURU_INSIGHTS = "DEVOPS_GURU_INSIGHTS"
    DIRECTORY_SERVICE = "DIRECTORY_SERVICE"
    DIRECT_CONNECT = "DIRECT_CONNECT"
    DISK = "DISK"
    DISTRO_FOR_OPENTELEMETRY = "DISTRO_FOR_OPENTELEMETRY"
    DOCUMENTDB_WITH_MONGODB_COMPATIBILITY = "DOCUMENTDB_WITH_MONGODB_COMPATIBILITY"
    DOCUMENTS = "DOCUMENTS"
    DOCUMENTS2 = "DOCUMENTS2"
    DOOR_LOCK = "DOOR_LOCK"
    DOWNLOAD_DISTRIBUTION = "DOWNLOAD_DISTRIBUTION"
    DYNAMODB = "DYNAMODB"
    DYNAMODB_DAX = "DYNAMODB_DAX"
    DYNAMODB_STANDARD_ACCESS_TABLE_CLASS = "DYNAMODB_STANDARD_ACCESS_TABLE_CLASS"
    DYNAMODB_STANDARD_INFREQUENT_ACCESS_TABLE_CLASS = "DYNAMODB_STANDARD_INFREQUENT_ACCESS_TABLE_CLASS"
    DYNAMODB_STREAM = "DYNAMODB_STREAM"
    EC2 = "EC2"
    EC2_AWS_MICROSERVICE_EXTRACTOR_FOR_NET = "EC2_AWS_MICROSERVICE_EXTRACTOR_FOR_NET"
    EC2_C6A_INSTANCE = "EC2_C6A_INSTANCE"
    EC2_C6GN_INSTANCE = "EC2_C6GN_INSTANCE"
    EC2_C6I_INSTANCE = "EC2_C6I_INSTANCE"
    EC2_C7G_INSTANCE = "EC2_C7G_INSTANCE"
    EC2_DL1_INSTANCE = "EC2_DL1_INSTANCE"
    EC2_G5G_INSTANCE = "EC2_G5G_INSTANCE"
    EC2_G5_INSTANCE = "EC2_G5_INSTANCE"
    EC2_HPC6A_INSTANCE = "EC2_HPC6A_INSTANCE"
    EC2_I4I_INSTANCE = "EC2_I4I_INSTANCE"
    EC2_IM4GN_INSTANCE = "EC2_IM4GN_INSTANCE"
    EC2_IMAGE_BUILDER = "EC2_IMAGE_BUILDER"
    EC2_INSTANCE_CONTENTS = "EC2_INSTANCE_CONTENTS"
    EC2_IS4GEN_INSTANCE = "EC2_IS4GEN_INSTANCE"
    EC2_M1_MAC_INSTANCE = "EC2_M1_MAC_INSTANCE"
    EC2_M6A_INSTANCE = "EC2_M6A_INSTANCE"
    EC2_M6I_INSTANCE = "EC2_M6I_INSTANCE"
    EC2_R6I_INSTANCE = "EC2_R6I_INSTANCE"
    EC2_TRN1_INSTANCE = "EC2_TRN1_INSTANCE"
    EC2_VT1_INSTANCE = "EC2_VT1_INSTANCE"
    EC2_X2GD_INSTANCE = "EC2_X2GD_INSTANCE"
    EC2_X2IDN_INSTANCE = "EC2_X2IDN_INSTANCE"
    EC2_X2IEDN_INSTANCE = "EC2_X2IEDN_INSTANCE"
    EC2_X2IEZN_INSTANCE = "EC2_X2IEZN_INSTANCE"
    ECHO = "ECHO"
    ECR = "ECR"
    ECS = "ECS"
    ECS_ANYWHERE = "ECS_ANYWHERE"
    ECS_COPILOT_CLI = "ECS_COPILOT_CLI"
    ECS_SERVICE = "ECS_SERVICE"
    ECS_TASK = "ECS_TASK"
    EDGE_LOCATION = "EDGE_LOCATION"
    EFS_INFREQUENTACCESS = "EFS_INFREQUENTACCESS"
    EFS_STANDARD = "EFS_STANDARD"
    EKS = "EKS"
    EKS_ANYWHERE = "EKS_ANYWHERE"
    EKS_CLOUD = "EKS_CLOUD"
    EKS_DISTRO = "EKS_DISTRO"
    ELASTICACHE = "ELASTICACHE"
    ELASTICACHE_FOR_MEMCACHED = "ELASTICACHE_FOR_MEMCACHED"
    ELASTICACHE_FOR_REDIS = "ELASTICACHE_FOR_REDIS"
    ELASTICSEARCH_SERVICE = "ELASTICSEARCH_SERVICE"
    ELASTIC_BEANSTALK = "ELASTIC_BEANSTALK"
    ELASTIC_BLOCK_STORE = "ELASTIC_BLOCK_STORE"
    ELASTIC_BLOCK_STORE_AMAZON_DATA_LIFECYCLE_MANAGER = "ELASTIC_BLOCK_STORE_AMAZON_DATA_LIFECYCLE_MANAGER"
    ELASTIC_BLOCK_STORE_VOLUME_GP3 = "ELASTIC_BLOCK_STORE_VOLUME_GP3"
    ELASTIC_FABRIC_ADAPTER = "ELASTIC_FABRIC_ADAPTER"
    ELASTIC_FILE_SYSTEM = "ELASTIC_FILE_SYSTEM"
    ELASTIC_FILE_SYSTEM_INFREQUENT_ACCESS = "ELASTIC_FILE_SYSTEM_INFREQUENT_ACCESS"
    ELASTIC_FILE_SYSTEM_INTELLIGENT_TIERING = "ELASTIC_FILE_SYSTEM_INTELLIGENT_TIERING"
    ELASTIC_FILE_SYSTEM_ONE_ZONE = "ELASTIC_FILE_SYSTEM_ONE_ZONE"
    ELASTIC_FILE_SYSTEM_ONE_ZONE_INFREQUENT_ACCESS = "ELASTIC_FILE_SYSTEM_ONE_ZONE_INFREQUENT_ACCESS"
    ELASTIC_FILE_SYSTEM_ONE_ZONE_STANDARD = "ELASTIC_FILE_SYSTEM_ONE_ZONE_STANDARD"
    ELASTIC_FILE_SYSTEM_STANDARD = "ELASTIC_FILE_SYSTEM_STANDARD"
    ELASTIC_FILE_SYSTEM_STANDARD_INFREQUENT_ACCESS = "ELASTIC_FILE_SYSTEM_STANDARD_INFREQUENT_ACCESS"
    ELASTIC_INFERENCE = "ELASTIC_INFERENCE"
    ELASTIC_INFERENCE_2 = "ELASTIC_INFERENCE_2"
    ELASTIC_IP_ADDRESS = "ELASTIC_IP_ADDRESS"
    ELASTIC_LOAD_BALANCING = "ELASTIC_LOAD_BALANCING"
    ELASTIC_NETWORK_ADAPTER = "ELASTIC_NETWORK_ADAPTER"
    ELASTIC_NETWORK_INTERFACE = "ELASTIC_NETWORK_INTERFACE"
    ELASTIC_TRANSCODER = "ELASTIC_TRANSCODER"
    ELEMENTAL = "ELEMENTAL"
    ELEMENTAL_LINK = "ELEMENTAL_LINK"
    ELEMENTAL_MEDIACONNECT = "ELEMENTAL_MEDIACONNECT"
    ELEMENTAL_MEDIACONVERT = "ELEMENTAL_MEDIACONVERT"
    ELEMENTAL_MEDIALIVE = "ELEMENTAL_MEDIALIVE"
    ELEMENTAL_MEDIAPACKAGE = "ELEMENTAL_MEDIAPACKAGE"
    ELEMENTAL_MEDIASTORE = "ELEMENTAL_MEDIASTORE"
    ELEMENTAL_MEDIATAILOR = "ELEMENTAL_MEDIATAILOR"
    EMAIL = "EMAIL"
    EMAIL_2 = "EMAIL_2"
    EMAIL_NOTIFICATION = "EMAIL_NOTIFICATION"
    EMR = "EMR"
    EMR_ENGINE = "EMR_ENGINE"
    EMR_ENGINE_MAPR_M3 = "EMR_ENGINE_MAPR_M3"
    EMR_ENGINE_MAPR_M5 = "EMR_ENGINE_MAPR_M5"
    EMR_ENGINE_MAPR_M7 = "EMR_ENGINE_MAPR_M7"
    ENCRYPTED_DATA = "ENCRYPTED_DATA"
    ENDPOINT = "ENDPOINT"
    ENDPOINTS = "ENDPOINTS"
    EVENT = "EVENT"
    EVENTBRIDGE = "EVENTBRIDGE"
    EVENTBRIDGE_CUSTOM_EVENT_BUS_RESOURCE = "EVENTBRIDGE_CUSTOM_EVENT_BUS_RESOURCE"
    EVENTBRIDGE_DEFAULT_EVENT_BUS_RESOURCE = "EVENTBRIDGE_DEFAULT_EVENT_BUS_RESOURCE"
    EVENTBRIDGE_SAAS_PARTNER_EVENT_BUS_RESOURCE = "EVENTBRIDGE_SAAS_PARTNER_EVENT_BUS_RESOURCE"
    EVENTBRIDGE_SCHEMA = "EVENTBRIDGE_SCHEMA"
    EVENTBRIDGE_SCHEMA_REGISTRY = "EVENTBRIDGE_SCHEMA_REGISTRY"
    EVENT_EVENT_BASED = "EVENT_EVENT_BASED"
    EVENT_RESOURCE = "EVENT_RESOURCE"
    EVENT_TIME_BASED = "EVENT_TIME_BASED"
    EXPRESS_WORKFLOW = "EXPRESS_WORKFLOW"
    EXTERNAL_SDK = "EXTERNAL_SDK"
    EXTERNAL_TOOLKIT = "EXTERNAL_TOOLKIT"
    F1_INSTANCE = "F1_INSTANCE"
    FACTORY = "FACTORY"
    FARGATE = "FARGATE"
    FAULT_INJECTION_SIMULATOR = "FAULT_INJECTION_SIMULATOR"
    FILE_GATEWAY = "FILE_GATEWAY"
    FILE_SYSTEM = "FILE_SYSTEM"
    FILTERING_RULE = "FILTERING_RULE"
    FINDING = "FINDING"
    FINSPACE = "FINSPACE"
    FIRETV = "FIRETV"
    FIRETV_STICK = "FIRETV_STICK"
    FIREWALL_MANAGER = "FIREWALL_MANAGER"
    FLEET_MANAGEMENT = "FLEET_MANAGEMENT"
    FLOW_LOGS = "FLOW_LOGS"
    FORECAST = "FORECAST"
    FORUMS = "FORUMS"
    FRAUD_DETECTOR = "FRAUD_DETECTOR"
    FREERTOS = "FREERTOS"
    FSX = "FSX"
    FSX_FILE_GATEWAY = "FSX_FILE_GATEWAY"
    FSX_FOR_LUSTRE = "FSX_FOR_LUSTRE"
    FSX_FOR_NETAPP_ONTAP = "FSX_FOR_NETAPP_ONTAP"
    FSX_FOR_OPENZFS = "FSX_FOR_OPENZFS"
    FSX_FOR_WINDOWS_FILE_SERVER = "FSX_FOR_WINDOWS_FILE_SERVER"
    G3_INSTANCE = "G3_INSTANCE"
    G4AD_INSTANCE = "G4AD_INSTANCE"
    G4DN = "G4DN"
    GAMEKIT = "GAMEKIT"
    GAMELIFT = "GAMELIFT"
    GAMESPARKS = "GAMESPARKS"
    GAME_TECH = "GAME_TECH"
    GAME_TECH2 = "GAME_TECH2"
    GATEWAY = "GATEWAY"
    GATEWAY_LOAD_BALANCER = "GATEWAY_LOAD_BALANCER"
    GEAR = "GEAR"
    GENERAL = "GENERAL"
    GENERAL_ACCESS_POINTS = "GENERAL_ACCESS_POINTS"
    GENERIC = "GENERIC"
    GENERIC_DATABASE = "GENERIC_DATABASE"
    GENERIC_FIREWALL = "GENERIC_FIREWALL"
    GENOMICS_CLI = "GENOMICS_CLI"
    GLACIER = "GLACIER"
    GLACIER_DEEP_ARCHIVE = "GLACIER_DEEP_ARCHIVE"
    GLOBAL_ACCELERATOR = "GLOBAL_ACCELERATOR"
    GLOBAL_SECONDARY_INDEX = "GLOBAL_SECONDARY_INDEX"
    GLUE = "GLUE"
    GLUE_CRAWLERS = "GLUE_CRAWLERS"
    GLUE_DATABREW = "GLUE_DATABREW"
    GLUE_DATA_CATALOG = "GLUE_DATA_CATALOG"
    GLUE_ELASTIC_VIEWS = "GLUE_ELASTIC_VIEWS"
    GREENGRASS = "GREENGRASS"
    GROUND_STATION = "GROUND_STATION"
    GROUP_ACCOUNT = "GROUP_ACCOUNT"
    GROUP_AUTO_SCALING_GROUP = "GROUP_AUTO_SCALING_GROUP"
    GROUP_AVAILABILITY_ZONE = "GROUP_AVAILABILITY_ZONE"
    GROUP_AWS_CLOUD = "GROUP_AWS_CLOUD"
    GROUP_AWS_CLOUD_ALT = "GROUP_AWS_CLOUD_ALT"
    GROUP_AWS_STEP_FUNCTIONS_WORKFLOW = "GROUP_AWS_STEP_FUNCTIONS_WORKFLOW"
    GROUP_CORPORATE_DATA_CENTER = "GROUP_CORPORATE_DATA_CENTER"
    GROUP_EC2_INSTANCE_CONTENTS = "GROUP_EC2_INSTANCE_CONTENTS"
    GROUP_ELASTIC_BEANSTALK = "GROUP_ELASTIC_BEANSTALK"
    GROUP_ELASTIC_LOAD_BALANCING = "GROUP_ELASTIC_LOAD_BALANCING"
    GROUP_IOT_GREENGRASS = "GROUP_IOT_GREENGRASS"
    GROUP_IOT_GREENGRASS_DEPLOYMENT = "GROUP_IOT_GREENGRASS_DEPLOYMENT"
    GROUP_ON_PREMISE = "GROUP_ON_PREMISE"
    GROUP_REGION = "GROUP_REGION"
    GROUP_SECURITY_GROUP = "GROUP_SECURITY_GROUP"
    GROUP_SPOT_FLEET = "GROUP_SPOT_FLEET"
    GROUP_SUBNET = "GROUP_SUBNET"
    GROUP_VPC = "GROUP_VPC"
    GUARDDUTY = "GUARDDUTY"
    H1_INSTANCE = "H1_INSTANCE"
    HABANA_GAUDI = "HABANA_GAUDI"
    HARDWARE_BOARD = "HARDWARE_BOARD"
    HDFS_CLUSTER = "HDFS_CLUSTER"
    HEALTHLAKE = "HEALTHLAKE"
    HIGH_MEMORY_INSTANCE = "HIGH_MEMORY_INSTANCE"
    HONEYCODE = "HONEYCODE"
    HOSTED_ZONE = "HOSTED_ZONE"
    HOUSE = "HOUSE"
    HTTP2_PROTOCOL = "HTTP2_PROTOCOL"
    HTTP_NOTIFICATION = "HTTP_NOTIFICATION"
    HTTP_PROTOCOL = "HTTP_PROTOCOL"
    I2 = "I2"
    I3EN = "I3EN"
    I3_INSTANCE = "I3_INSTANCE"
    IDENTITY_AND_ACCESS_MANAGEMENT = "IDENTITY_AND_ACCESS_MANAGEMENT"
    ILLUSTRATION_DESKTOP = "ILLUSTRATION_DESKTOP"
    ILLUSTRATION_DEVICES = "ILLUSTRATION_DEVICES"
    ILLUSTRATION_NOTIFICATION = "ILLUSTRATION_NOTIFICATION"
    ILLUSTRATION_OFFICE_BUILDING = "ILLUSTRATION_OFFICE_BUILDING"
    ILLUSTRATION_USERS = "ILLUSTRATION_USERS"
    IMPORT_EXPORT = "IMPORT_EXPORT"
    INF1 = "INF1"
    INFERENTIA = "INFERENTIA"
    INFREQUENT_ACCESS_STORAGE_CLASS = "INFREQUENT_ACCESS_STORAGE_CLASS"
    INSPECTOR = "INSPECTOR"
    INSTANCE = "INSTANCE"
    INSTANCE2 = "INSTANCE2"
    INSTANCES = "INSTANCES"
    INSTANCES_2 = "INSTANCES_2"
    INSTANCE_WITH_CLOUDWATCH = "INSTANCE_WITH_CLOUDWATCH"
    INSTANCE_WITH_CLOUDWATCH2 = "INSTANCE_WITH_CLOUDWATCH2"
    INTELLIGENT_TIERING = "INTELLIGENT_TIERING"
    INTERACTIVE_VIDEO = "INTERACTIVE_VIDEO"
    INTERNET = "INTERNET"
    INTERNET_ALT1 = "INTERNET_ALT1"
    INTERNET_ALT2 = "INTERNET_ALT2"
    INTERNET_ALT22 = "INTERNET_ALT22"
    INTERNET_GATEWAY = "INTERNET_GATEWAY"
    INTERNET_OF_THINGS = "INTERNET_OF_THINGS"
    INVENTORY = "INVENTORY"
    IOT_1CLICK = "IOT_1CLICK"
    IOT_ANALYTICS = "IOT_ANALYTICS"
    IOT_ANALYTICS_CHANNEL = "IOT_ANALYTICS_CHANNEL"
    IOT_ANALYTICS_DATA_STORE = "IOT_ANALYTICS_DATA_STORE"
    IOT_ANALYTICS_PIPELINE = "IOT_ANALYTICS_PIPELINE"
    IOT_BUTTON = "IOT_BUTTON"
    IOT_CORE = "IOT_CORE"
    IOT_DEVICE_DEFENDER = "IOT_DEVICE_DEFENDER"
    IOT_DEVICE_DEFENDER_IOT_DEVICE_JOBS = "IOT_DEVICE_DEFENDER_IOT_DEVICE_JOBS"
    IOT_DEVICE_GATEWAY = "IOT_DEVICE_GATEWAY"
    IOT_DEVICE_JOBS_RESOURCE = "IOT_DEVICE_JOBS_RESOURCE"
    IOT_DEVICE_MANAGEMENT = "IOT_DEVICE_MANAGEMENT"
    IOT_EVENTS = "IOT_EVENTS"
    IOT_EXPRESSLINK = "IOT_EXPRESSLINK"
    IOT_FLEETWISE = "IOT_FLEETWISE"
    IOT_GREENGRASS_ARTIFACT = "IOT_GREENGRASS_ARTIFACT"
    IOT_GREENGRASS_COMPONENT = "IOT_GREENGRASS_COMPONENT"
    IOT_GREENGRASS_COMPONENT_MACHINE_LEARNING = "IOT_GREENGRASS_COMPONENT_MACHINE_LEARNING"
    IOT_GREENGRASS_COMPONENT_NUCLEUS = "IOT_GREENGRASS_COMPONENT_NUCLEUS"
    IOT_GREENGRASS_COMPONENT_PRIVATE = "IOT_GREENGRASS_COMPONENT_PRIVATE"
    IOT_GREENGRASS_COMPONENT_PUBLIC = "IOT_GREENGRASS_COMPONENT_PUBLIC"
    IOT_GREENGRASS_INTERPROCESS_COMMUNICATION = "IOT_GREENGRASS_INTERPROCESS_COMMUNICATION"
    IOT_GREENGRASS_PROTOCOL = "IOT_GREENGRASS_PROTOCOL"
    IOT_GREENGRASS_RECIPE = "IOT_GREENGRASS_RECIPE"
    IOT_GREENGRASS_STREAM_MANAGER = "IOT_GREENGRASS_STREAM_MANAGER"
    IOT_LORAWAN_PROTOCOL = "IOT_LORAWAN_PROTOCOL"
    IOT_OVER_THE_AIR_UPDATE = "IOT_OVER_THE_AIR_UPDATE"
    IOT_ROBORUNNER = "IOT_ROBORUNNER"
    IOT_SAILBOAT = "IOT_SAILBOAT"
    IOT_SITEWISE = "IOT_SITEWISE"
    IOT_SITEWISE_ASSET = "IOT_SITEWISE_ASSET"
    IOT_SITEWISE_ASSET_HIERARCHY = "IOT_SITEWISE_ASSET_HIERARCHY"
    IOT_SITEWISE_ASSET_MODEL = "IOT_SITEWISE_ASSET_MODEL"
    IOT_SITEWISE_ASSET_PROPERTIES = "IOT_SITEWISE_ASSET_PROPERTIES"
    IOT_SITEWISE_DATA_STREAMS = "IOT_SITEWISE_DATA_STREAMS"
    IOT_THINGS_GRAPH = "IOT_THINGS_GRAPH"
    IOT_THING_FREERTOS_DEVICE = "IOT_THING_FREERTOS_DEVICE"
    IOT_THING_HUMIDITY_SENSOR = "IOT_THING_HUMIDITY_SENSOR"
    IOT_THING_INDUSTRIAL_PC = "IOT_THING_INDUSTRIAL_PC"
    IOT_THING_PLC = "IOT_THING_PLC"
    IOT_THING_RELAY = "IOT_THING_RELAY"
    IOT_THING_STACKLIGHT = "IOT_THING_STACKLIGHT"
    IOT_THING_TEMPERATURE_HUMIDITY_SENSOR = "IOT_THING_TEMPERATURE_HUMIDITY_SENSOR"
    IOT_THING_TEMPERATURE_SENSOR = "IOT_THING_TEMPERATURE_SENSOR"
    IOT_THING_TEMPERATURE_VIBRATION_SENSOR = "IOT_THING_TEMPERATURE_VIBRATION_SENSOR"
    IOT_THING_VIBRATION_SENSOR = "IOT_THING_VIBRATION_SENSOR"
    IOT_TWINMAKER = "IOT_TWINMAKER"
    IQ = "IQ"
    ITEM = "ITEM"
    ITEMS = "ITEMS"
    KENDRA = "KENDRA"
    KEYSPACES = "KEYSPACES"
    KEY_MANAGEMENT_SERVICE = "KEY_MANAGEMENT_SERVICE"
    KINESIS = "KINESIS"
    KINESIS_DATA_ANALYTICS = "KINESIS_DATA_ANALYTICS"
    KINESIS_DATA_FIREHOSE = "KINESIS_DATA_FIREHOSE"
    KINESIS_DATA_STREAMS = "KINESIS_DATA_STREAMS"
    KINESIS_VIDEO_STREAMS = "KINESIS_VIDEO_STREAMS"
    LAKE_FORMATION = "LAKE_FORMATION"
    LAMBDA = "LAMBDA"
    LAMBDA_FUNCTION = "LAMBDA_FUNCTION"
    LAYERS = "LAYERS"
    LEX = "LEX"
    LICENSE_MANAGER = "LICENSE_MANAGER"
    LICENSE_MANAGER_APPLICATION_DISCOVERY = "LICENSE_MANAGER_APPLICATION_DISCOVERY"
    LICENSE_MANAGER_LICENSE_BLENDING = "LICENSE_MANAGER_LICENSE_BLENDING"
    LIGHTBULB = "LIGHTBULB"
    LIGHTSAIL = "LIGHTSAIL"
    LOCAL_ZONES = "LOCAL_ZONES"
    LOCATION_SERVICE = "LOCATION_SERVICE"
    LOCATION_SERVICE_GEOFENCE = "LOCATION_SERVICE_GEOFENCE"
    LOCATION_SERVICE_MAP = "LOCATION_SERVICE_MAP"
    LOCATION_SERVICE_PLACE = "LOCATION_SERVICE_PLACE"
    LOCATION_SERVICE_ROUTES = "LOCATION_SERVICE_ROUTES"
    LOCATION_SERVICE_TRACK = "LOCATION_SERVICE_TRACK"
    LOGS = "LOGS"
    LONG_TERM_SECURITY_CREDENTIAL = "LONG_TERM_SECURITY_CREDENTIAL"
    LOOKOUT_FOR_EQUIPMENT = "LOOKOUT_FOR_EQUIPMENT"
    LOOKOUT_FOR_METRICS = "LOOKOUT_FOR_METRICS"
    LOOKOUT_FOR_VISION = "LOOKOUT_FOR_VISION"
    LUMBERYARD = "LUMBERYARD"
    M4_INSTANCE = "M4_INSTANCE"
    M5A_INSTANCE = "M5A_INSTANCE"
    M5DN_INSTANCE = "M5DN_INSTANCE"
    M5D_INSTANCE = "M5D_INSTANCE"
    M5N = "M5N"
    M5N_INSTANCE = "M5N_INSTANCE"
    M5ZN_INSTANCE = "M5ZN_INSTANCE"
    M5_INSTANCE = "M5_INSTANCE"
    M6GD_INSTANCE = "M6GD_INSTANCE"
    M6G_INSTANCE = "M6G_INSTANCE"
    MACHINE_LEARNING = "MACHINE_LEARNING"
    MACIE = "MACIE"
    MAC_INSTANCE = "MAC_INSTANCE"
    MAINFRAME_MODERNIZATION = "MAINFRAME_MODERNIZATION"
    MAINFRAME_MODERNIZATION_ANALYZER = "MAINFRAME_MODERNIZATION_ANALYZER"
    MAINFRAME_MODERNIZATION_COMPILER = "MAINFRAME_MODERNIZATION_COMPILER"
    MAINFRAME_MODERNIZATION_CONVERTER = "MAINFRAME_MODERNIZATION_CONVERTER"
    MAINFRAME_MODERNIZATION_DEVELOPER = "MAINFRAME_MODERNIZATION_DEVELOPER"
    MAINFRAME_MODERNIZATION_RUNTIME = "MAINFRAME_MODERNIZATION_RUNTIME"
    MAINTENANCE_WINDOWS = "MAINTENANCE_WINDOWS"
    MANAGED_APACHE_CASSANDRA_SERVICE = "MANAGED_APACHE_CASSANDRA_SERVICE"
    MANAGED_BLOCKCHAIN = "MANAGED_BLOCKCHAIN"
    MANAGED_MS_AD = "MANAGED_MS_AD"
    MANAGED_SERVICES = "MANAGED_SERVICES"
    MANAGED_SERVICE_FOR_GRAFANA = "MANAGED_SERVICE_FOR_GRAFANA"
    MANAGED_SERVICE_FOR_PROMETHEUS = "MANAGED_SERVICE_FOR_PROMETHEUS"
    MANAGED_STREAMING_FOR_KAFKA = "MANAGED_STREAMING_FOR_KAFKA"
    MANAGED_WORKFLOWS_FOR_APACHE_AIRFLOW = "MANAGED_WORKFLOWS_FOR_APACHE_AIRFLOW"
    MANAGEMENT_AND_GOVERNANCE = "MANAGEMENT_AND_GOVERNANCE"
    MANAGEMENT_CONSOLE = "MANAGEMENT_CONSOLE"
    MARKETPLACE = "MARKETPLACE"
    MEDIA_SERVICES = "MEDIA_SERVICES"
    MEDICAL_EMERGENCY = "MEDICAL_EMERGENCY"
    MEMORYDB_FOR_REDIS = "MEMORYDB_FOR_REDIS"
    MESH = "MESH"
    MESSAGE = "MESSAGE"
    MFA_TOKEN = "MFA_TOKEN"
    MIGRATION_AND_TRANSFER = "MIGRATION_AND_TRANSFER"
    MIGRATION_EVALUATOR = "MIGRATION_EVALUATOR"
    MIGRATION_HUB = "MIGRATION_HUB"
    MIGRATION_HUB_REFACTOR_SPACES_APPLICATIONS = "MIGRATION_HUB_REFACTOR_SPACES_APPLICATIONS"
    MIGRATION_HUB_REFACTOR_SPACES_ENVIRONMENTS = "MIGRATION_HUB_REFACTOR_SPACES_ENVIRONMENTS"
    MIGRATION_HUB_REFACTOR_SPACES_SERVICES = "MIGRATION_HUB_REFACTOR_SPACES_SERVICES"
    MOBILE = "MOBILE"
    MOBILE_APPLICATION = "MOBILE_APPLICATION"
    MOBILE_CLIENT = "MOBILE_CLIENT"
    MOBILE_HUB = "MOBILE_HUB"
    MONITORING = "MONITORING"
    MONITRON = "MONITRON"
    MQ = "MQ"
    MQTT_PROTOCOL = "MQTT_PROTOCOL"
    MQ_BROKER = "MQ_BROKER"
    MSK_AMAZON_MSK_CONNECT = "MSK_AMAZON_MSK_CONNECT"
    MS_SQL_INSTANCE = "MS_SQL_INSTANCE"
    MS_SQL_INSTANCE_ALTERNATE = "MS_SQL_INSTANCE_ALTERNATE"
    MULTIMEDIA = "MULTIMEDIA"
    MULTIPLE_VOLUMES_RESOURCE = "MULTIPLE_VOLUMES_RESOURCE"
    MYSQL_DB_INSTANCE = "MYSQL_DB_INSTANCE"
    MYSQL_DB_INSTANCE_ALTERNATE = "MYSQL_DB_INSTANCE_ALTERNATE"
    NAMESPACE = "NAMESPACE"
    NAT_GATEWAY = "NAT_GATEWAY"
    NEPTUNE = "NEPTUNE"
    NETWORKING_AND_CONTENT_DELIVERY = "NETWORKING_AND_CONTENT_DELIVERY"
    NETWORK_ACCESS_CONTROL_LIST = "NETWORK_ACCESS_CONTROL_LIST"
    NETWORK_FIREWALL = "NETWORK_FIREWALL"
    NETWORK_FIREWALL_ENDPOINTS = "NETWORK_FIREWALL_ENDPOINTS"
    NETWORK_LOAD_BALANCER = "NETWORK_LOAD_BALANCER"
    NEURON_ML_SDK = "NEURON_ML_SDK"
    NICE_DCV = "NICE_DCV"
    NICE_ENGINFRAME = "NICE_ENGINFRAME"
    NIMBLE_STUDIO = "NIMBLE_STUDIO"
    NITRO_ENCLAVES = "NITRO_ENCLAVES"
    NON_CACHED_VOLUME = "NON_CACHED_VOLUME"
    NOTEBOOK = "NOTEBOOK"
    OBJECT = "OBJECT"
    OFFICE_BUILDING = "OFFICE_BUILDING"
    ONE_ZONE_IA = "ONE_ZONE_IA"
    OPEN_3D_ENGINE = "OPEN_3D_ENGINE"
    OPSWORKS = "OPSWORKS"
    OPSWORKS_APPS = "OPSWORKS_APPS"
    OPSWORKS_PERMISSIONS = "OPSWORKS_PERMISSIONS"
    OPTIMIZED_INSTANCE = "OPTIMIZED_INSTANCE"
    ORACLE_DB_INSTANCE = "ORACLE_DB_INSTANCE"
    ORACLE_DB_INSTANCE_ALTERNATE = "ORACLE_DB_INSTANCE_ALTERNATE"
    ORGANIZATIONS = "ORGANIZATIONS"
    ORGANIZATIONS_ACCOUNT = "ORGANIZATIONS_ACCOUNT"
    ORGANIZATIONS_ACCOUNT2 = "ORGANIZATIONS_ACCOUNT2"
    ORGANIZATIONS_MANAGEMENT_ACCOUNT = "ORGANIZATIONS_MANAGEMENT_ACCOUNT"
    ORGANIZATIONS_MANAGEMENT_ACCOUNT2 = "ORGANIZATIONS_MANAGEMENT_ACCOUNT2"
    ORGANIZATIONS_ORGANIZATIONAL_UNIT = "ORGANIZATIONS_ORGANIZATIONAL_UNIT"
    ORGANIZATIONS_ORGANIZATIONAL_UNIT2 = "ORGANIZATIONS_ORGANIZATIONAL_UNIT2"
    OUTPOSTS = "OUTPOSTS"
    OUTPOSTS_1U_AND_2U_SERVERS = "OUTPOSTS_1U_AND_2U_SERVERS"
    OUTPOSTS_FAMILY = "OUTPOSTS_FAMILY"
    P2_INSTANCE = "P2_INSTANCE"
    P3DN_INSTANCE = "P3DN_INSTANCE"
    P3_INSTANCE = "P3_INSTANCE"
    P4D_INSTANCE = "P4D_INSTANCE"
    P4_INSTANCE = "P4_INSTANCE"
    PANORAMA = "PANORAMA"
    PARALLEL_CLUSTER = "PARALLEL_CLUSTER"
    PARAMETER_STORE = "PARAMETER_STORE"
    PATCH_MANAGER = "PATCH_MANAGER"
    PEERING = "PEERING"
    PERMISSIONS = "PERMISSIONS"
    PERMISSIONS_2 = "PERMISSIONS_2"
    PERSONALIZE = "PERSONALIZE"
    PERSONAL_HEALTH_DASHBOARD = "PERSONAL_HEALTH_DASHBOARD"
    PINPOINT = "PINPOINT"
    PINPOINT_JOURNEY = "PINPOINT_JOURNEY"
    POLICE_EMERGENCY = "POLICE_EMERGENCY"
    POLICY = "POLICY"
    POLLY = "POLLY"
    POSTGRESQL_INSTANCE = "POSTGRESQL_INSTANCE"
    PRIVATELINK = "PRIVATELINK"
    PRIVATE_5G = "PRIVATE_5G"
    PROFESSIONAL_SERVICES = "PROFESSIONAL_SERVICES"
    PROTON = "PROTON"
    QUANTUM_LEDGER_DATABASE = "QUANTUM_LEDGER_DATABASE"
    QUANTUM_TECHNOLOGIES = "QUANTUM_TECHNOLOGIES"
    QUESTION = "QUESTION"
    QUEUE = "QUEUE"
    QUICKSIGHT = "QUICKSIGHT"
    R4_INSTANCE = "R4_INSTANCE"
    R5AD_INSTANCE = "R5AD_INSTANCE"
    R5A_INSTANCE = "R5A_INSTANCE"
    R5B_INSTANCE = "R5B_INSTANCE"
    R5D_INSTANCE = "R5D_INSTANCE"
    R5GD_INSTANCE = "R5GD_INSTANCE"
    R5N = "R5N"
    R5N_INSTANCE = "R5N_INSTANCE"
    R5_INSTANCE = "R5_INSTANCE"
    R6G_INSTANCE = "R6G_INSTANCE"
    RDN_INSTANCE = "RDN_INSTANCE"
    RDS = "RDS"
    RDS_INSTANCE = "RDS_INSTANCE"
    RDS_INSTANCE_ALT = "RDS_INSTANCE_ALT"
    RDS_MARIADB_INSTANCE = "RDS_MARIADB_INSTANCE"
    RDS_MARIADB_INSTANCE_ALT = "RDS_MARIADB_INSTANCE_ALT"
    RDS_MULTI_AZ = "RDS_MULTI_AZ"
    RDS_MULTI_AZ_DB_CLUSTER = "RDS_MULTI_AZ_DB_CLUSTER"
    RDS_MYSQL_INSTANCE = "RDS_MYSQL_INSTANCE"
    RDS_MYSQL_INSTANCE_ALT = "RDS_MYSQL_INSTANCE_ALT"
    RDS_ON_VMWARE = "RDS_ON_VMWARE"
    RDS_ORACLE_INSTANCE = "RDS_ORACLE_INSTANCE"
    RDS_ORACLE_INSTANCE_ALT = "RDS_ORACLE_INSTANCE_ALT"
    RDS_PIOP = "RDS_PIOP"
    RDS_PIOPS = "RDS_PIOPS"
    RDS_POSTGRESQL_INSTANCE = "RDS_POSTGRESQL_INSTANCE"
    RDS_POSTGRESQL_INSTANCE_ALT = "RDS_POSTGRESQL_INSTANCE_ALT"
    RDS_PROXY = "RDS_PROXY"
    RDS_PROXY_ALT = "RDS_PROXY_ALT"
    RDS_SQL_SERVER_INSTANCE = "RDS_SQL_SERVER_INSTANCE"
    RDS_SQL_SERVER_INSTANCE_ALT = "RDS_SQL_SERVER_INSTANCE_ALT"
    REDSHIFT = "REDSHIFT"
    REDSHIFT_ML = "REDSHIFT_ML"
    REDSHIFT_RA3 = "REDSHIFT_RA3"
    RED_HAT_OPENSHIFT = "RED_HAT_OPENSHIFT"
    REGISTRY = "REGISTRY"
    REKOGNITION = "REKOGNITION"
    REKOGNITION_2 = "REKOGNITION_2"
    REKOGNITION_IMAGE = "REKOGNITION_IMAGE"
    REKOGNITION_VIDEO = "REKOGNITION_VIDEO"
    REPLICATION = "REPLICATION"
    REPLICATION_TIME_CONTROL = "REPLICATION_TIME_CONTROL"
    REPORTED_STATE = "REPORTED_STATE"
    REPOST = "REPOST"
    RESCUE = "RESCUE"
    RESERVED_INSTANCE_REPORTING = "RESERVED_INSTANCE_REPORTING"
    RESILIENCE_HUB = "RESILIENCE_HUB"
    RESOURCE = "RESOURCE"
    RESOURCES = "RESOURCES"
    RESOURCE_ACCESS_MANAGER = "RESOURCE_ACCESS_MANAGER"
    ROBOMAKER = "ROBOMAKER"
    ROBOTICS = "ROBOTICS"
    ROLE = "ROLE"
    ROUTER = "ROUTER"
    ROUTE_53 = "ROUTE_53"
    ROUTE_53_APPLICATION_RECOVERY_CONTROLLER = "ROUTE_53_APPLICATION_RECOVERY_CONTROLLER"
    ROUTE_53_READINESS_CHECKS = "ROUTE_53_READINESS_CHECKS"
    ROUTE_53_RESOLVER = "ROUTE_53_RESOLVER"
    ROUTE_53_RESOLVER_DNS_FIREWALL = "ROUTE_53_RESOLVER_DNS_FIREWALL"
    ROUTE_53_RESOLVER_QUERY_LOGGING = "ROUTE_53_RESOLVER_QUERY_LOGGING"
    ROUTE_53_ROUTING_CONTROLS = "ROUTE_53_ROUTING_CONTROLS"
    ROUTE_TABLE = "ROUTE_TABLE"
    RULE = "RULE"
    RULE_2 = "RULE_2"
    RULE_3 = "RULE_3"
    RUN_COMMAND = "RUN_COMMAND"
    S3 = "S3"
    S3_FILE_GATEWAY = "S3_FILE_GATEWAY"
    S3_OBJECT_LAMBDA = "S3_OBJECT_LAMBDA"
    S3_OBJECT_LAMBDA_ACCESS_POINTS = "S3_OBJECT_LAMBDA_ACCESS_POINTS"
    S3_ON_OUTPOSTS = "S3_ON_OUTPOSTS"
    S3_ON_OUTPOSTS_STORAGE = "S3_ON_OUTPOSTS_STORAGE"
    S3_REPLICATION_TIME_CONTROL = "S3_REPLICATION_TIME_CONTROL"
    S3_STORAGE_LENS = "S3_STORAGE_LENS"
    SAAS_EVENT_BUS_RESOURCE = "SAAS_EVENT_BUS_RESOURCE"
    SAGEMAKER = "SAGEMAKER"
    SAGEMAKER_CANVAS = "SAGEMAKER_CANVAS"
    SAGEMAKER_GROUND_TRUTH = "SAGEMAKER_GROUND_TRUTH"
    SAGEMAKER_MODEL = "SAGEMAKER_MODEL"
    SAGEMAKER_NOTEBOOK = "SAGEMAKER_NOTEBOOK"
    SAGEMAKER_STUDIO_LAB = "SAGEMAKER_STUDIO_LAB"
    SAGEMAKER_TRAIN = "SAGEMAKER_TRAIN"
    SAML_TOKEN = "SAML_TOKEN"
    SATELLITE = "SATELLITE"
    SAVINGS_PLANS = "SAVINGS_PLANS"
    SEARCH_DOCUMENTS = "SEARCH_DOCUMENTS"
    SECRETS_MANAGER = "SECRETS_MANAGER"
    SECURITY_GROUP = "SECURITY_GROUP"
    SECURITY_HUB = "SECURITY_HUB"
    SECURITY_HUB_FINDING = "SECURITY_HUB_FINDING"
    SECURITY_IDENTITY_AND_COMPLIANCE = "SECURITY_IDENTITY_AND_COMPLIANCE"
    SENSOR = "SENSOR"
    SERVERLESS = "SERVERLESS"
    SERVERLESS_APPLICATION_REPOSITORY = "SERVERLESS_APPLICATION_REPOSITORY"
    SERVER_MIGRATION_SERVICE = "SERVER_MIGRATION_SERVICE"
    SERVICE = "SERVICE"
    SERVICE_CATALOG = "SERVICE_CATALOG"
    SERVO = "SERVO"
    SHADOW = "SHADOW"
    SHIELD = "SHIELD"
    SHIELD_SHIELD_ADVANCED = "SHIELD_SHIELD_ADVANCED"
    SIGNER = "SIGNER"
    SIMPLE_AD = "SIMPLE_AD"
    SIMPLE_EMAIL_SERVICE = "SIMPLE_EMAIL_SERVICE"
    SIMPLE_STORAGE_SERVICE_S3_GLACIER_INSTANT_RETRIEVAL = "SIMPLE_STORAGE_SERVICE_S3_GLACIER_INSTANT_RETRIEVAL"
    SIMULATION = "SIMULATION"
    SIMULATOR = "SIMULATOR"
    SINGLE_SIGN_ON = "SINGLE_SIGN_ON"
    SITE_TO_SITE_VPN = "SITE_TO_SITE_VPN"
    SNAPSHOT = "SNAPSHOT"
    SNOWBALL = "SNOWBALL"
    SNOWBALL_EDGE = "SNOWBALL_EDGE"
    SNOWCONE = "SNOWCONE"
    SNOWMOBILE = "SNOWMOBILE"
    SNS = "SNS"
    SPOT_INSTANCE = "SPOT_INSTANCE"
    SQL_PRIMARY = "SQL_PRIMARY"
    SQL_REPLICA = "SQL_REPLICA"
    SQL_WORKBENCH = "SQL_WORKBENCH"
    SQS = "SQS"
    SSL_PADLOCK = "SSL_PADLOCK"
    STACK = "STACK"
    STACK2 = "STACK2"
    STANDARD_IA = "STANDARD_IA"
    STATE_MANAGER = "STATE_MANAGER"
    STEP_FUNCTIONS = "STEP_FUNCTIONS"
    STORAGE = "STORAGE"
    STORAGE_GATEWAY = "STORAGE_GATEWAY"
    STREAMING_DISTRIBUTION = "STREAMING_DISTRIBUTION"
    STS = "STS"
    STS_ALTERNATE = "STS_ALTERNATE"
    SUMERIAN = "SUMERIAN"
    SUPPORT = "SUPPORT"
    SYSTEMS_MANAGER = "SYSTEMS_MANAGER"
    SYSTEMS_MANAGER_INCIDENT_MANAGER = "SYSTEMS_MANAGER_INCIDENT_MANAGER"
    SYSTEMS_MANAGER_OPSCENTER = "SYSTEMS_MANAGER_OPSCENTER"
    T2_INSTANCE = "T2_INSTANCE"
    T3A_INSTANCE = "T3A_INSTANCE"
    T3_INSTANCE = "T3_INSTANCE"
    T4G_INSTANCE = "T4G_INSTANCE"
    TABLE = "TABLE"
    TAPE_GATEWAY = "TAPE_GATEWAY"
    TAPE_STORAGE = "TAPE_STORAGE"
    TEMPLATE = "TEMPLATE"
    TEMPORARY_SECURITY_CREDENTIAL = "TEMPORARY_SECURITY_CREDENTIAL"
    TENSORFLOW_ON_AWS = "TENSORFLOW_ON_AWS"
    TEXTRACT = "TEXTRACT"
    THERMOSTAT = "THERMOSTAT"
    THINKBOX_DEADLINE = "THINKBOX_DEADLINE"
    THINKBOX_DRAFT = "THINKBOX_DRAFT"
    THINKBOX_FROST = "THINKBOX_FROST"
    THINKBOX_KRAKATOA = "THINKBOX_KRAKATOA"
    THINKBOX_SEQUOIA = "THINKBOX_SEQUOIA"
    THINKBOX_STOKE = "THINKBOX_STOKE"
    THINKBOX_XMESH = "THINKBOX_XMESH"
    TIMESTREAM = "TIMESTREAM"
    TOOLS_AND_SDKS = "TOOLS_AND_SDKS"
    TOPIC = "TOPIC"
    TOPIC_2 = "TOPIC_2"
    TORCHSERVE = "TORCHSERVE"
    TRADITIONAL_SERVER = "TRADITIONAL_SERVER"
    TRAINING_CERTIFICATION = "TRAINING_CERTIFICATION"
    TRAINIUM_INSTANCE = "TRAINIUM_INSTANCE"
    TRANSCRIBE = "TRANSCRIBE"
    TRANSFER_FAMILY = "TRANSFER_FAMILY"
    TRANSFER_FOR_FTPS_RESOURCE = "TRANSFER_FOR_FTPS_RESOURCE"
    TRANSFER_FOR_FTP_RESOURCE = "TRANSFER_FOR_FTP_RESOURCE"
    TRANSFER_FOR_SFTP = "TRANSFER_FOR_SFTP"
    TRANSFER_FOR_SFTP_RESOURCE = "TRANSFER_FOR_SFTP_RESOURCE"
    TRANSIT_GATEWAY = "TRANSIT_GATEWAY"
    TRANSIT_GATEWAY_ATTACHMENT = "TRANSIT_GATEWAY_ATTACHMENT"
    TRANSLATE = "TRANSLATE"
    TRAVEL = "TRAVEL"
    TRUSTED_ADVISOR = "TRUSTED_ADVISOR"
    USER = "USER"
    USERS = "USERS"
    UTILITY = "UTILITY"
    VAULT = "VAULT"
    VIRTUAL_GATEWAY = "VIRTUAL_GATEWAY"
    VIRTUAL_NODE = "VIRTUAL_NODE"
    VIRTUAL_PRIVATE_CLOUD = "VIRTUAL_PRIVATE_CLOUD"
    VIRTUAL_ROUTER = "VIRTUAL_ROUTER"
    VIRTUAL_SERVICE = "VIRTUAL_SERVICE"
    VIRTUAL_TAPE_LIBRARY = "VIRTUAL_TAPE_LIBRARY"
    VMWARE_CLOUD_ON_AWS = "VMWARE_CLOUD_ON_AWS"
    VOLUME = "VOLUME"
    VOLUME_GATEWAY = "VOLUME_GATEWAY"
    VPC = "VPC"
    VPC_ACCESS_POINTS = "VPC_ACCESS_POINTS"
    VPC_CARRIER_GATEWAY = "VPC_CARRIER_GATEWAY"
    VPC_NETWORK_ACCESS_ANALYZER = "VPC_NETWORK_ACCESS_ANALYZER"
    VPC_PRIVATELINK = "VPC_PRIVATELINK"
    VPC_REACHABILITY_ANALYZER = "VPC_REACHABILITY_ANALYZER"
    VPC_TRAFFIC_MIRRORING = "VPC_TRAFFIC_MIRRORING"
    VPN_CONNECTION = "VPN_CONNECTION"
    VPN_GATEWAY = "VPN_GATEWAY"
    WAF = "WAF"
    WAF_BAD_BOT = "WAF_BAD_BOT"
    WAF_BOT = "WAF_BOT"
    WAF_BOT_CONTROL = "WAF_BOT_CONTROL"
    WAF_LABELS = "WAF_LABELS"
    WAF_MANAGED_RULE = "WAF_MANAGED_RULE"
    WAF_RULE = "WAF_RULE"
    WAVELENGTH = "WAVELENGTH"
    WELL_ARCHITECTED_TOOL = "WELL_ARCHITECTED_TOOL"
    WELL_ARCHITECT_TOOL = "WELL_ARCHITECT_TOOL"
    WINDFARM = "WINDFARM"
    WORKDOCS = "WORKDOCS"
    WORKLINK = "WORKLINK"
    WORKMAIL = "WORKMAIL"
    WORKSPACES = "WORKSPACES"
    WORKSPACES_WORKSPACES_WEB = "WORKSPACES_WORKSPACES_WEB"
    X1E_INSTANCE = "X1E_INSTANCE"
    X1_INSTANCE = "X1_INSTANCE"
    X1_INSTANCE2 = "X1_INSTANCE2"
    XRAY = "XRAY"
    Z1D_INSTANCE = "Z1D_INSTANCE"


__all__ = [
    "ShapeNames",
]

publication.publish()
