/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Graph } from "../../../../../../cdk-graph";
import * as Dot from "ts-graphviz";
import { INodePosition } from "../../../config";
/**
 * Node class defines a {@link Graph.Node} based diagram {@link Dot.Node}
 * @internal
 */
export declare class Node extends Dot.Node {
    /** Reference to the {@link Graph.Node} this diagram {@link Dot.Node} is based on  */
    readonly graphNode: Graph.Node;
    /** Get the label attribute for this node */
    get label(): string;
    set position(pos: INodePosition);
    /** @internal */
    constructor(node: Graph.Node);
}
/**
 * ImageNode class extends {@link Node} with support for rendering diagram images.
 * @internal
 */
export declare class ImageNode extends Node {
    /** @internal */
    constructor(node: Graph.Node, image?: string);
    /** Get `image` attribute */
    get image(): string | undefined;
    /** Resizes the node based on image and label dimensions */
    resize(baseHeight?: number): void;
}
/**
 * CfnResourceNode class defines a {@link Dot.Node} based on a {@link Graph.CfnResourceNode}
 * @internal
 */
export declare class CfnResourceNode extends ImageNode {
    /** @internal */
    constructor(node: Graph.CfnResourceNode);
}
/**
 * ResourceNode class defines a {@link Dot.Node} based on a {@link Graph.ResourceNode}
 * @internal
 */
export declare class ResourceNode extends ImageNode {
    /** @internal */
    constructor(node: Graph.ResourceNode);
}
/**
 * CustomResourceNode class defines a {@link Dot.Node} based on a {@link Graph.Node} for a *custom resource*
 * @internal
 */
export declare class CustomResourceNode extends ImageNode {
    /** @internal */
    constructor(node: Graph.Node);
}
