import * as svgson from "svgson";
/**
 * Add graph font css styles to svg
 * @internal
 */
export declare function addGraphFontCssStyles(svg: svgson.INode): void;
/**
 * Resolve SVG image paths to inline base64 **Data URLs**.
 * @internal
 */
export declare function resolveSvgAwsArchAssetImagesInline(svgString: string): Promise<string>;
/**
 * Encode buffer as base64 encoded **Data URL**
 * @internal
 */
export declare function encodeDataUrl(buffer: Buffer, prefix: string): string;
/**
 * Encode string as html and base64 encoded **Data URL**
 * @internal
 */
export declare function encodeHtmlDataUrl(data: string, prefix: string): string;
/**
 * Encode SVG file as base64 encoded **Data URL**
 * @internal
 */
export declare function encodeSvgFileDataUrl(svgFile: string): Promise<string>;
/**
 * SVG `viewBox` struct
 * @internal
 */
export interface SvgViewBox {
    readonly x: number;
    readonly y: number;
    readonly width?: number;
    readonly height?: number;
}
/**
 * Reconcile svg viewBox attribute based on root container ([g](https://developer.mozilla.org/en-US/docs/Web/SVG/Element/g)) scale.
 *
 * This will modify the viewbox and root container in place.
 * @param svg Svg to reconcile
 * @throws Error if svg does not define `viewBox` attribute
 * @internal
 */
export declare function reconcileViewBox(svg: svgson.INode): void;
/**
 * Get SVG root container - the first "g" element
 * @internal
 */
export declare function getSvgRootContainer(svg: svgson.INode): svgson.INode | undefined;
/** Parse SVG viewBox */
export declare function parseSvgViewBox(svgOrViewBox: svgson.INode | string): SvgViewBox | undefined;
/** Stringify SVG viewBox attribute */
export declare function stringifySvgViewBox(viewBox: SvgViewBox): string;
/** Parse SVG transform attribute scale property */
export declare function parseSvgTransformScale(elementOrTransform: svgson.INode | string): number[] | undefined;
/**
 * Unescape SVG **text** values.
 *
 * *dot-wasm* escapes svg text ("-" -> "&#45;") and [svgson](https://github.com/elrumordelaluz/svgson/blob/e7234b645b4e344f525d4d2fde2d3f2911d3a75a/src/stringify.js#L20)
 * escapes strings that contain *&...* by wrapping in `<![CDATA[...]]>` tag which causes the
 * resulting text value in SVG and PNG files to show raw escaped value (`&#45;`).
 *
 * We expect to have the original text values rendered rather than escaped version rendered.
 *
 * @example `Diagram (hyphenated&#45;value)` => `Diagram (hyphenated-value)`
 * @internal
 */
export declare function unescapeSvgTextValues(svg: svgson.INode): void;
