import { CloudscapeReactTsWebsiteProject } from "../../../../../cloudscape-react-ts-website";
import { TypeSafeApiProject } from "../../../../../type-safe-api";
import { AwsCdkJavaApp } from "projen/lib/awscdk";
import { AwsCdkJavaAppOptions } from "./aws-cdk-java-app-options";
import { DeploymentStage } from "../../components/deployment-stage";
/**
 * Configuration options for the InfrastructureJavaProject.
 */
export interface InfrastructureJavaProjectOptions extends AwsCdkJavaAppOptions {
    /**
     * Stack name.
     *
     * @default infra-dev
     */
    readonly stackName?: string;
    /**
     * List of deployment stages.
     */
    readonly stages?: DeploymentStage[];
    /**
     * Allow self sign up for the UserIdentity construct.
     *
     * @default - false
     */
    readonly allowSignup?: boolean;
    /**
     * TypeSafeApi instance to use when setting up the initial project sample code.
     * @deprecated use typeSafeApis
     */
    readonly typeSafeApi?: TypeSafeApiProject;
    /**
     * CloudscapeReactTsWebsiteProject instance to use when setting up the initial project sample code.
     * @deprecated use cloudscapeReactTsWebsites
     */
    readonly cloudscapeReactTsWebsite?: CloudscapeReactTsWebsiteProject;
    /**
     * TypeSafeApi instances to use when setting up the initial project sample code.
     */
    readonly typeSafeApis?: TypeSafeApiProject[];
    /**
     * CloudscapeReactTsWebsiteProject instances to use when setting up the initial project sample code.
     */
    readonly cloudscapeReactTsWebsites?: CloudscapeReactTsWebsiteProject[];
}
/**
 * Synthesizes a Infrastructure Java Project.
 */
export declare class InfrastructureJavaProject extends AwsCdkJavaApp {
    constructor(options: InfrastructureJavaProjectOptions);
    private generateTypeSafeMustacheConfig;
    private capitalize;
    private emitSampleFiles;
}
