/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { IRepository } from "aws-cdk-lib/aws-codecommit";
import { CodePipelineProps, ShellStepProps } from "aws-cdk-lib/pipelines";
import { Construct } from "constructs";
export interface FeatureBranchesProps extends Pick<CodePipelineProps, "codeBuildDefaults" | "dockerEnabledForSynth"> {
    /**
     * Branch name prefixes
     * Any branches created matching this list of prefixes will create a new pipeline and stack.
     *
     * @example
     * // Creates a new pipeline and stack for any branch
     * new PDKPipeline(this, 'PDKPipeline', {
     *   repositoryName: 'my-repo',
     *   branchNamePrefixes: [''],
     * }
     * @example
     * // Creates a new pipeline and stack for any branch starting with 'feature/' or 'fix/'
     * new PDKPipeline(this, 'PDKPipeline', {
     *   repositoryName: 'my-repo',
     *   branchNamePrefixes: ['feature/', 'fix/'],
     * }
     * @example
     * // Disables feature branches (default)
     * new PDKPipeline(this, 'PDKPipeline', {
     *   repositoryName: 'my-repo',
     *   branchNamePrefixes: [], // or simply exclude this line
     * }
     */
    readonly branchNamePrefixes: string[];
    /**
     * The directory with `cdk.json` to run cdk synth from.
     */
    readonly cdkSrcDir: string;
    /**
     * The CodeCommit repository.
     */
    readonly codeRepository: IRepository;
    /**
     * Default branch.
     */
    readonly defaultBranchName: string;
    /**
     * PDKPipeline by default assumes a NX Monorepo structure for it's codebase and
     * uses sane defaults for the install and run commands. To override these defaults
     * and/or provide additional inputs, specify env settings, etc you can provide
     * a partial ShellStepProps.
     */
    readonly synthShellStepPartialProps?: ShellStepProps;
    /**
     * CDK command. Override the command used to call cdk for synth and deploy.
     *
     * @default 'npx cdk'
     */
    readonly cdkCommand?: string;
}
export declare class FeatureBranches extends Construct {
    constructor(scope: Construct, id: string, props: FeatureBranchesProps);
}
