import { IFunction } from "aws-cdk-lib/aws-lambda";
import { IBucket } from "aws-cdk-lib/aws-s3";
/**
 * Generate the lambda function invocation uri for the given lambda within the given scope
 * @param lambdaFunction the lambda function to be invoked
 */
export declare const functionInvocationUri: (lambdaFunction: IFunction) => string;
/**
 * Generate the s3 bucket invocation uri for the given s3 within the given scope
 * @param bucket the s3 bucket to be invoked
 * @param path? the path to object to invoke, default to none
 */
export declare const bucketInvocationUri: (bucket: IBucket, path?: string) => string;
