import { Task } from "projen";
import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedProjectOptions } from "../../types";
import { CodegenOptions } from "../components/utils";
/**
 * Configuration for the generated typescript client project
 */
export interface GeneratedTypescriptRuntimeBaseProjectOptions extends TypeScriptProjectOptions, GeneratedProjectOptions, CodeGenerationSourceOptions {
    /**
     * Whether this project is parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
/**
 * Typescript project containing types generated using OpenAPI Generator CLI
 */
export declare abstract class GeneratedTypescriptRuntimeBaseProject extends TypeScriptProject {
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedTypescriptRuntimeBaseProjectOptions;
    protected readonly generateTask: Task;
    constructor(options: GeneratedTypescriptRuntimeBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildCodegenOptions(): CodegenOptions;
}
