/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Project, ProjectOptions } from "projen";
import { OpenApiAsyncDefinitionOptions, OpenApiAsyncDefinition } from "./open-api-async-definition";
import { TypeSafeApiAsyncModelBuildOutputOptions } from "../type-safe-api-async-model-build";
import { TypeSafeApiModelBuildOutputOptions } from "../type-safe-api-model-build";
/**
 * Options for an OpenAPI WebSocket API model
 */
export interface OpenApiAsyncModelProjectOptions extends ProjectOptions, OpenApiAsyncDefinitionOptions, TypeSafeApiModelBuildOutputOptions, TypeSafeApiAsyncModelBuildOutputOptions {
}
/**
 * Project for defining an OpenAPI model for a WebSocket API
 */
export declare class OpenApiAsyncModelProject extends Project {
    /**
     * Name of the API
     */
    readonly apiName: string;
    /**
     * OpenAPI specification component
     */
    readonly definition: OpenApiAsyncDefinition;
    constructor(options: OpenApiAsyncModelProjectOptions);
}
